

<section class="dashboard-profile-section ptb-80">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-7 col-lg-8 col-md-10">
                <form method="POST" action="<?php echo e(setRoute('user.profile.update')); ?>" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <div class="dashboard-profile-area">
                        <div class="user-profile">
                            <div class="preview-thumb profile-thumb">
                                <?php if(auth()->user()->image): ?>
                                    <div class="avatar-preview">
                                        <div class="profilePicPreview bg_img"
                                            data-background="<?php echo e(get_image(auth()->user()->image, 'user-profile')); ?>">
                                        </div>
                                    </div>
                                <?php else: ?>
                                    <div class="avatar-preview">
                                        <div class="profilePicPreview bg_img"
                                            data-background="<?php echo e(asset('public/frontend/images/element/user.png')); ?>">
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <div class="avatar-edit">
                                    <input type='file' class="profilePicUpload" name="image" id="profilePicUpload2"
                                        accept=".png, .jpg, .jpeg">
                                    <label for="profilePicUpload2"><i class="las la-upload"></i></label>
                                </div>
                            </div>
                            <div class="user-name">
                                <h4><?php echo e(__(auth()->user()->username)); ?></h4>
                                <p><i class="las la-envelope"></i> <?php echo e(__(auth()->user()->email)); ?></p>
                            </div>
                        </div>
                        <div class="profile-form-area">
                            <div class="row mb-10-none">
                                <div class="col-lg-6 col-md-6 col-sm-12 mb-10">
                                    <label><?php echo e(__('First Name')); ?></label>
                                    <input type="text" class="form--control"
                                        value="<?php echo e(__(auth()->user()->firstname)); ?>" name="firstname">
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-12 mb-10">
                                    <label><?php echo e(__('Last Name')); ?></label>
                                    <input type="text" class="form--control"
                                        value="<?php echo e(__(auth()->user()->lastname)); ?>" name="lastname">
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-12 mb-10">
                                    <label><?php echo e(__('Phone Number')); ?></label>
                                    <div class="input-group">
                                        <div class="input-group-text phone-code">+<?php echo e(auth()->user()->mobile_code); ?>

                                        </div>
                                        <input class="phone-code" type="hidden" name="phone_code"
                                            value="<?php echo e(auth()->user()->mobile_code); ?>" />
                                        <input type="number" class="form--control"
                                            placeholder="<?php echo e(__('enter Phone Number')); ?>" name="mobile"
                                            value="<?php echo e(__(auth()->user()->mobile)); ?>">
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-12 mb-10">
                                    <label><?php echo e(__('Email Address')); ?></label>
                                    <input type="email" class="form--control" value="<?php echo e(__(auth()->user()->email)); ?>"
                                        name="email">
                                </div>
                                <div class="col-lg-12 col-md-12 col-sm-12 mb-10">
                                    <label><?php echo e(__('Country')); ?></label>
                                    <select class="form--control select-2 select2-auto-tokenize country-select"
                                        data-placeholder="Select Country" name="country"
                                        data-old="<?php echo e(old('country', auth()->user()->address->country ?? '')); ?>"
                                        name="country">
                                    </select>
                                </div>
                                <div class="col-lg-12 col-md-12 col-sm-12 mb-10">
                                    <label><?php echo e(__('Address')); ?></label>
                                    <input type="text" class="form--control" value="<?php echo e(auth()->user()->address->address ?? ''); ?>"
                                        name="address" placeholder="Enter Address">
                                </div>
                            </div>
                            <div class="save-btn pt-4">
                                <button type="submit" class="btn--base w-100"><?php echo e(__('Update Now')); ?></button>
                            </div>
                            <div class="save-btn pt-4">
                                <a class="delete-btn text-white btn--danger w-100" href="javascript:void(0)"><?php echo e(__('Delete Profile')); ?></a>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</section>


<?php $__env->startPush('script'); ?>
    <script>
        $(".delete-btn").click(function() {
            var actionRoute = "<?php echo e(setRoute('user.profile.delete')); ?>";
            var target = 1;
            var message = `<?php echo e(__('Are you sure to')); ?> <strong><?php echo e(__('Delete')); ?></strong> <?php echo e(__('your profile')); ?>`;
            openAlertModal(actionRoute, target, message, "<?php echo e(__('Delete')); ?>", "GET");
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH C:\xampp\htdocs\Payload\resources\views/user/sections/profile/profile-section.blade.php ENDPATH**/ ?>