<?php $__env->startPush('css'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo $__env->make('admin.components.page-title',['title' => __($page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('admin.components.breadcrumb',['breadcrumbs' => [
        [
            'name'  => __("Dashboard"),
            'url'   => setRoute("admin.dashboard"),
        ]
    ], 'active' => __("Data Bundle Logs")], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="table-area">
    <div class="table-wrapper">
        <div class="table-header">
            <h5 class="title"><?php echo e($page_title); ?></h5>
            <?php if(count($transactions) > 0): ?>
            <?php endif; ?>
        </div>
        <div class="table-responsive">
            <table class="custom-table">
                <thead>
                    <tr>
                        <th><?php echo e(__("TRX ID")); ?></th>
                        <th><?php echo e(__("Fullname")); ?></th>
                        <th><?php echo e(__("TopUp Type")); ?></th>
                        <th><?php echo e(__("Mobile Number")); ?></th>
                        <th><?php echo e(__("TOPUP AMOUNT")); ?></th>
                        <th><?php echo e(__(("Status"))); ?></th>
                        <th><?php echo e(__("Time")); ?></th>
                        <th><?php echo e(__("Action")); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $transactions ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>

                        <tr>
                            <td><?php echo e($item->trx_id); ?></td>

                            <td>
                                <?php if($item->user_id != null): ?>
                                    <a href="<?php echo e(setRoute('admin.users.details',$item->user->username)); ?>"><?php echo e($item->user->username); ?></a>
                                <?php endif; ?>
                            </td>

                            <td ><span class="fw-bold"><?php echo e(@$item->details->topup_type_name); ?></span></td>
                            <td ><span class="fw-bold"><?php echo e(@$item->details->mobile_number); ?></span></td>
                            <td><?php echo e(get_amount($item->request_amount,$item->request_currency)); ?></td>
                            <td>
                                <span class="<?php echo e($item->stringStatus->class); ?>"><?php echo e(__($item->stringStatus->value)); ?></span>
                            </td>
                            <td><?php echo e($item->created_at->format('d-m-y h:i:s A')); ?></td>
                            <td>
                                <?php echo $__env->make('admin.components.link.info-default',[
                                    'href'          => setRoute('admin.data.bundle.details', $item->id),
                                    'permission'    => "admin.data.bundle.details",
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                         <?php echo $__env->make('admin.components.alerts.empty',['colspan' => 10], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <?php echo e(get_paginate($transactions)); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Payload\resources\views/admin/sections/data-bundles/index.blade.php ENDPATH**/ ?>