<?php $__env->startPush('css'); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo $__env->make('admin.components.page-title', ['title' => __($page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('admin.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Dashboard'),
                'url' => setRoute('admin.dashboard'),
            ],
        ],
        'active' => __($page_title),
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="custom-card">
        <div class="card-header">
            <h6 class="title"><?php echo e(__('Gift Card API')); ?></h6>
        </div>
        <div class="card-body">
            <form class="card-form" action="<?php echo e(setRoute('admin.gift.card.api.update')); ?>" method="POST"
                enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="row mb-10-none">
                    <div class="col-xl-12 col-lg-12 form-group">
                        <label><?php echo e(__('name')); ?>*</label>
                        <select class="form--control nice-select" name="api_method">
                            <option disabled><?php echo e(__('Select Platfrom')); ?></option>
                            <option value="reloadly" <?php if(@$api->config->name == 'reloadly'): ?> selected <?php endif; ?>><?php echo app('translator')->get('Reloadly API'); ?>
                            </option>
                        </select>
                    </div>
                    <div class="col-xl-12 col-lg-12 form-group configForm" id="reloadly">
                        <div class="row">
                            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12 form-group">
                                <label><?php echo e(__('Client ID')); ?>*</label>
                                <div class="input-group append">
                                    <span class="input-group-text"><i class="las la-key"></i></span>
                                    <input type="text" class="form--control" name="reloadly_client_id"
                                        value="<?php echo e(@$api->credentials->client_id); ?>">
                                </div>
                            </div>
                            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12 form-group">
                                <label><?php echo e(__('secret Key')); ?>*</label>
                                <div class="input-group append">
                                    <span class="input-group-text"><i class="las la-key"></i></span>
                                    <input type="text" class="form--control" name="reloadly_secret_key"
                                        value="<?php echo e(@$api->credentials->secret_key); ?>">
                                </div>
                            </div>
                            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12 form-group">
                                <label><?php echo e(__('Production URL')); ?>*</label>
                                <div class="input-group append">
                                    <span class="input-group-text"><i class="las la-link"></i></span>
                                    <input type="text" class="form--control" name="reloadly_production_base_url"
                                        value="<?php echo e(@$api->credentials->production_base_url); ?>">
                                </div>
                            </div>
                            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12 form-group">
                                <label><?php echo e(__('Sandbox URL')); ?>*</label>
                                <div class="input-group append">
                                    <span class="input-group-text"><i class="las la-link"></i></span>
                                    <input type="text" class="form--control" name="reloadly_sandbox_base_url"
                                        value="<?php echo e(@$api->credentials->sandbox_base_url); ?>">
                                </div>
                            </div>
                            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12 form-group">
                                <label><?php echo e(__('Webhook URL')); ?></label>
                                <div class="input-group append">
                                    <span class="input-group-text"><i class="las la-link"></i></span>
                                    <input type="text" class="form--control" id="referralURL"
                                        value="<?php echo e(setRoute('user.gift.card.webhook')); ?>" readonly>
                                    <div class="input-group-text copytext" id="copyBoard"><i class="las la-copy"></i></div>
                                </div>
                            </div>
                            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12 form-group">
                                <?php echo $__env->make('admin.components.form.switcher', [
                                    'label' => __('Api ENV') . '*',
                                    'value' => old('    ', @$api->env),
                                    'name' => 'reloadly_env',
                                    'options' => [
                                        __('Production') => global_const()::ENV_PRODUCTION,
                                        __('Sandbox') => global_const()::ENV_SANDBOX,
                                    ],
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                            <div class="col-xl-12 col-lg-12 form-group mt-4">
                                <?php echo $__env->make('admin.components.button.form-btn', [
                                    'class' => 'w-100 btn-loading',
                                    'text' => __('Update'),
                                    'permission' => 'admin.virtual.card.api.update',
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>



<?php $__env->startPush('script'); ?>
    <script>
        $('.copytext').on('click', function() {
            var copyText = document.getElementById("referralURL");
            copyText.select();
            copyText.setSelectionRange(0, 99999);
            document.execCommand("copy");

            throwMessage('success', ['<?php echo e(__('URL Copied To Clipboard!')); ?>']);
        });
    </script>

    <script>
        (function($) {
            "use strict";
            var method = '<?php echo e(@$api->config->name); ?>';
            if (!method) {
                method = 'reloadly';
            }

            apiMethod(method);
            $('select[name=api_method]').on('change', function() {
                var method = $(this).val();
                apiMethod(method);
            });

            function apiMethod(method) {
                $('.configForm').addClass('d-none');
                if (method != 'other') {
                    $(`#${method}`).removeClass('d-none');
                }
            }

        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Payload\resources\views/admin/sections/gift-card/api.blade.php ENDPATH**/ ?>