<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('user.components.breadcrumb',['breadcrumbs' => [
        [
            'name'  => __("Dashboard"),
            'url'   => setRoute("user.dashboard"),
        ]
    ], 'active' => __($page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="my-gift-card ptb-80">
    <div class="container">
        <div class="giftcard-list">
            <div class="table-header-title">
                <div class="table-name mb-10">
                    <h3 class="title"><?php echo e(__($page_title)); ?></h3>
                </div>
                <div class="add-btn text-end mb-10">
                    <a href="<?php echo e(setRoute('user.gift.card.list')); ?>" class="btn--base"><i class="fas la-plus"></i> <?php echo e(__('Add Gift Card')); ?></a>
                </div>
            </div>

            <div class="row">
                <div class="col-12">
                    <div class="table-responsive">
                        <table class="table table-striped custom-table">
                            <thead>
                                <tr>
                                    <th><?php echo e(__("TRX ID")); ?></th>
                                    <th><?php echo e(__("Card Name")); ?></th>
                                    <th><?php echo e(__("Card Images")); ?></th>
                                    <th><?php echo e(__("Receiver Email")); ?></th>
                                    <th><?php echo e(__("Receiver Phone")); ?></th>
                                    <th><?php echo e(__("Card Unit Price")); ?></th>
                                    <th><?php echo e(__("Card Quantity")); ?></th>
                                    <th><?php echo e(__("Card Total Price")); ?></th>
                                    <th><?php echo e(__("Exchange Rate")); ?></th>
                                    <th><?php echo e(__("Payable Unit Price")); ?></th>
                                    <th><?php echo e(__("Total Charge")); ?></th>
                                    <th><?php echo e(__("Payable Amount")); ?></th>
                                    <th><?php echo e(__("Status")); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $giftCards ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($item->trx_id); ?></td>
                                    <td><?php echo e($item->card_name); ?></td>
                                    <td><img style="max-width: 50px" src="<?php echo e($item->card_image); ?> " alt=""></td>
                                    <td><?php echo e($item->recipient_email); ?></td>
                                    <td>+<?php echo e($item->recipient_phone); ?></td>
                                    <td><?php echo e(get_amount($item->card_amount,$item->card_currency)); ?></td>
                                    <td><?php echo e($item->qty); ?></td>
                                    <td><?php echo e(get_amount($item->card_total_amount,$item->card_currency)); ?></td>
                                    <td><?php echo e(get_amount(1,$item->card_currency) ." = ". get_amount($item->exchange_rate,$item->user_wallet_currency)); ?></td>
                                    <td><?php echo e(get_amount($item->unit_amount,$item->user_wallet_currency)); ?></td>
                                    <td><?php echo e(get_amount($item->total_charge,$item->user_wallet_currency)); ?></td>
                                    <td><?php echo e(get_amount($item->total_payable,$item->user_wallet_currency)); ?></td>
                                    <td><span class="<?php echo e($item->stringStatus->class); ?>"><?php echo e(__($item->stringStatus->value)); ?> </span></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <?php echo $__env->make('admin.components.alerts.empty2',['colspan' => 13], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                <?php endif; ?>

                            </tbody>
                        </table>
                        <nav>
                            <?php echo e(get_paginate($giftCards)); ?>

                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Payload\resources\views/user/sections/gift-card/index.blade.php ENDPATH**/ ?>