<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    Flexiplan preview
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
<section class="flexiplan-preview-section ptb-80">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-7 col-md-9 col-sm-12">
                <div class="get-package-area">
                    <h3 class="title"><i class="fas fa-info-circle text--base mb-20"></i><?php echo e(__('Your Bundle')); ?></h3>
                    <div class="plan-preview">
                        <div class="plan-name">
                            <span class="badge badge--base"><?php echo e(__('Operator Name')); ?></span>
                        </div>
                        <div class="plan-quantity">
                            <span><?php echo e($charges['operator_name']); ?></span>
                        </div>
                    </div>
                    <div class="plan-preview">
                        <div class="plan-name">
                            <span class="badge badge--base"><?php echo e(__('Bundle')); ?></span>
                        </div>
                        <div class="plan-quantity">
                            <span><?php echo e($info['name']); ?></span>
                        </div>
                    </div>
                    <div class="plan-preview">
                        <div class="plan-name">
                            <span class="badge badge--base"><?php echo e(__('Price')); ?></span>
                        </div>
                        <div class="plan-quantity">
                            <span><?php echo e($charges['amount']); ?> <?php echo e($charges['bundle_currency']); ?></span>
                        </div>
                    </div>
                    <div class="plan-preview">
                        <div class="plan-name">
                            <span class="badge badge--base"><?php echo e(__('Exchange Rate')); ?></span>
                        </div>
                        <div class="plan-quantity">
                            <span>1 <?php echo e($charges['bundle_currency']); ?> = <?php echo e($charges['exchange_rate']); ?> <?php echo e($charges['wallet_currency_code']); ?></span>
                        </div>
                    </div>
                    <div class="plan-preview">
                        <div class="plan-name">
                            <span class="badge badge--base"><?php echo e(__('Total Payable')); ?></span>
                        </div>
                        <div class="plan-quantity">
                            <span><?php echo e($charges['total_payable']); ?> <?php echo e($charges['wallet_currency_code']); ?></span>
                        </div>
                    </div>
                    <form action="<?php echo e(setRoute('user.data.bundle.buy')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="package-number pt-20">
                            <div class="package-select">
                                <label><?php echo e(__('For Number')); ?> :</label>
                            </div>
                            <input type="number" name="phone" id="number-input" class="form--control"
                                value="<?php echo e(auth()->user()->full_mobile); ?>">
                            <input name="request_amount" class="d-none" value="<?php echo e($charges['amount']); ?>">
                            <input name="operator_id" class="d-none" value="<?php echo e($charges['operator']['operatorId']); ?>">
                            <input name="geo_location" class="d-none" value="<?php echo e($info['geo_location']); ?>">
                            <input name="iso2" class="d-none" value="<?php echo e($info['iso2']); ?>">
                            <input name="charges" class="d-none" value="<?php echo e(json_encode($charges)); ?>">
                            <div class="mobile-icon">
                                <i class="las la-mobile"></i>
                            </div>
                        </div>
                        <div class="planbuy-btn pt-20">
                            <button type="submit" class="btn--base w-100"><?php echo e(__('Buy Now')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>
<?php /**PATH C:\xampp\htdocs\Payload\resources\views/user/sections/data-bundle/bundle-preview.blade.php ENDPATH**/ ?>