<!DOCTYPE html>
<html lang="<?php echo e(get_default_language_code()); ?>">

<?php
    $cookie = App\Models\Admin\SiteSections::siteCookie();
    
    //cookies results
    $approval_status = request()->cookie('approval_status');
    $c_user_agent = request()->cookie('user_agent');
    $c_ip_address = request()->cookie('ip_address');
    $c_browser = request()->cookie('browser');
    $c_platform = request()->cookie('platform');
    //system informations
    $s_ipAddress = request()->ip();
    $s_location = geoip()->getLocation($s_ipAddress);
    $s_browser = Agent::browser();
    $s_platform = Agent::platform();
    $s_agent = request()->header('User-Agent');
?>

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo e(isset($page_title) ? __($page_title) : __('Public')); ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@100;200;300;400;500;600;700;800;900&display=swap"
        rel="stylesheet">

    <?php echo $__env->make('partials.header-asset', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->yieldPushContent('css'); ?>
</head>

<body <?php if($defualt === 'ar'): ?> class="rtl" <?php endif; ?>>

    
    <?php echo $__env->make('frontend.partials.scroll-to-top', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="section-wrapper">
        <div class="inner-wrapper">
            <?php echo $__env->make('frontend.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <?php echo $__env->yieldContent('content'); ?>

        </div>
        <?php echo $__env->make('frontend.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
    <?php echo $__env->make('partials.footer-asset', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('frontend.partials.extensions.tawk-to', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('frontend.partials.notify', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <?php echo $__env->yieldPushContent('script'); ?>

    <script>
        var status = "<?php echo e(@$cookie->status); ?>";
         //cookies results
         var approval_status      = "<?php echo e($approval_status); ?>";
         var c_user_agent         = "<?php echo e($c_user_agent); ?>";
         var c_ip_address         = "<?php echo e($c_ip_address); ?>";
         var c_browser            = "<?php echo e($c_browser); ?>";
         var c_platform           = "<?php echo e($c_platform); ?>";
         //system informations
        var s_ipAddress    = "<?php echo e($s_ipAddress); ?>";
        var s_browser      = "<?php echo e($s_browser); ?>";
        var s_platform     = "<?php echo e($s_platform); ?>";
        var s_agent        = "<?php echo e($s_agent); ?>";
        const pop = document.querySelector('.cookie-main-wrapper')
        if( status == 1){
            if(approval_status == 'allow' || approval_status == 'decline' || c_user_agent === s_agent || c_ip_address === s_ipAddress || c_browser === s_browser || c_platform === s_platform){
                pop.style.bottom = "-300px";
            }else{
                window.onload = function(){
                setTimeout(function(){
                    pop.style.bottom = "20px";
                }, 2000)
            }
            }
        }else{
            pop.style.bottom = "-300px";
        }
        // })
    </script>
    <script>
        (function ($) {
            "use strict";
            //Allow
            $('.cookie-btn').on('click', function() {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                var postData = {
                    type: "allow",
                };
                $.post('<?php echo e(route('global.set.cookie')); ?>', postData, function(response) {
                    throwMessage('success', [response]);
                    setTimeout(function() {
                        location.reload();
                    }, 1000);
                });
            });
            //Decline
            $('.cookie-btn-cross').on('click', function() {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                var postData = {
                    type: "decline",
                };
                $.post('<?php echo e(route('global.set.cookie')); ?>', postData, function(response) {
                    throwMessage('error',[response]);
                    setTimeout(function(){
                        location.reload();
                    },1000);
                });
            });
        })(jQuery)
    </script>

</body>

</html>
<?php /**PATH D:\xampp\htdocs\Payload\resources\views/frontend/layouts/master.blade.php ENDPATH**/ ?>