<?php $__env->startPush('css'); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo $__env->make('admin.components.page-title', ['title' => __($page_title)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('admin.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Dashboard'),
                'url' => setRoute('admin.dashboard'),
            ],
        ],
        'active' => __('Dashboard'),
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="dashboard-area">
        <div class="dashboard-item-area">
            <div class="row">
                <div class="col-xxxl-4 col-xxl-3 col-xl-3 col-lg-6 col-md-6 col-sm-12 mb-15">
                    <div class="dashbord-item">
                        <div class="dashboard-content">
                            <div class="left">
                                <h6 class="title"><?php echo e(__('Add Money Balance')); ?></h6>
                                <div class="user-info">
                                    <h2 class="user-count"><?php echo e(get_default_currency_symbol()); ?><?php echo e(getAmount($data['recharge_money_total_balance'], 2)); ?></h2>
                                </div>
                                <div class="user-badge">
                                    <span class="badge badge--info"><?php echo e(__('Total')); ?>

                                        <?php echo e(getAmount($data['completed_recharge_money'] + $data['pending_recharge_money'])); ?></span>
                                    <span class="badge badge--warning"><?php echo e(__('Pending')); ?>

                                        <?php echo e(getAmount($data['pending_recharge_money'])); ?></span>
                                </div>
                            </div>
                            <div class="right">
                                <div class="chart" id="chart7" data-percent="<?php echo e($data['recharge_money_percent']); ?>">
                                    <span><?php echo e(getAmount($data['recharge_money_percent'],0)); ?>% </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxxl-4 col-xxl-3 col-xl-3 col-lg-6 col-md-6 col-sm-12 mb-15">
                    <div class="dashbord-item">
                        <div class="dashboard-content">
                            <div class="left">
                                <h6 class="title"><?php echo e(__('Gift Card')); ?></h6>
                                <div class="user-info">
                                    <h2 class="user-count"><?php echo e(get_default_currency_symbol()); ?><?php echo e(getAmount($data['total_gift_card'])); ?></h2>
                                </div>
                                <div class="user-badge">
                                    <span class="badge badge--info"><?php echo e(__('This Month')); ?>

                                        <?php echo e(get_default_currency_symbol()); ?><?php echo e(getAmount($data['gift_card_this_month'])); ?>

                                    </span>
                                    <span class="badge badge--warning"><?php echo e(__('Last Month')); ?>

                                        <?php echo e(get_default_currency_symbol()); ?><?php echo e(getAmount($data['gift_card_last_month'])); ?>

                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxxl-4 col-xxl-3 col-xl-3 col-lg-6 col-md-6 col-sm-12 mb-15">
                    <div class="dashbord-item">
                        <div class="dashboard-content">
                            <div class="left">
                                <h6 class="title"><?php echo e(__('Mobile Topup')); ?></h6>
                                <div class="user-info">
                                    <h2 class="user-count"><?php echo e(get_default_currency_symbol()); ?><?php echo e(getAmount($data['total_mobile_topup'])); ?></h2>
                                </div>
                                <div class="user-badge">
                                    <span class="badge badge--info"><?php echo e(__('This month')); ?>

                                        <?php echo e(get_default_currency_symbol()); ?><?php echo e(getAmount($data['mobile_topup_this_month'])); ?>

                                    </span>
                                    <span class="badge badge--warning"><?php echo e(__('Last month')); ?>

                                        <?php echo e(get_default_currency_symbol()); ?><?php echo e(getAmount($data['mobile_topup_last_month'])); ?>

                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxxl-4 col-xxl-3 col-xl-3 col-lg-6 col-md-6 col-sm-12 mb-15">
                    <div class="dashbord-item">
                        <div class="dashboard-content">
                            <div class="left">
                                <h6 class="title"><?php echo e(__('Total Profit')); ?></h6>
                                <div class="user-info">
                                    <h2 class="user-count"><?php echo e(get_default_currency_symbol()); ?><?php echo e(getAmount($data['total_profits'],2)); ?></h2>
                                </div>
                                <div class="user-badge">
                                    <span class="badge badge--info"><?php echo e(__('This Month')); ?>

                                        <?php echo e(get_default_currency_symbol()); ?>

                                        <?php echo e(getAmount($data['this_month_profits'])); ?></span>
                                    <span class="badge badge--warning"><?php echo e(__('Last Month')); ?>

                                        <?php echo e(get_default_currency_symbol()); ?>

                                        <?php echo e(getAmount($data['last_month_profits'])); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxxl-4 col-xxl-3 col-xl-3 col-lg-6 col-md-6 col-sm-12 mb-15">
                    <div class="dashbord-item">
                        <div class="dashboard-content">
                            <div class="left">
                                <h6 class="title"><?php echo e(__("Total Users")); ?></h6>
                                <div class="user-info">
                                    <h2 class="user-count"><?php echo e($data['total_users']); ?></h2>
                                </div>
                                <div class="user-badge">
                                    <span class="badge badge--info"><?php echo e(__("Verified")); ?> <?php echo e($data['verified_users']); ?></span>
                                    <span class="badge badge--warning"><?php echo e(__("Unverified")); ?> <?php echo e($data['unverified_users']); ?></span>
                                </div>
                            </div>
                            <div class="right">
                                <div class="chart" id="chart12" data-percent="<?php echo e($data['user_percent']); ?>"><span><?php echo e(round($data['user_percent'],2)); ?>%</span></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxxl-4 col-xxl-3 col-xl-3 col-lg-6 col-md-6 col-sm-12 mb-15">
                    <div class="dashbord-item">
                        <div class="dashboard-content">
                            <div class="left">
                                <h6 class="title"><?php echo e(__("Total Supports Tickets")); ?></h6>
                                <div class="user-info">
                                    <h2 class="user-count"><?php echo e($data['total_tickets']); ?></h2>
                                </div>
                                <div class="user-badge">
                                    <span class="badge badge--info"><?php echo e(__("active")); ?> <?php echo e($data['active_tickets']); ?></span>
                                    <span class="badge badge--warning"><?php echo e(__("Pending")); ?> <?php echo e($data['pending_tickets']); ?></span>
                                </div>
                            </div>
                            <div class="right">
                                <div class="chart" id="chart15" data-percent="<?php echo e($data['ticket_percent']); ?>"><span><?php echo e(round($data['ticket_percent'],2)); ?>%</span></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="chart-area mt-15">
        <div class="row mb-15-none">
            <div class="col-xxl-6 col-xl-6 col-lg-6 mb-15">
                <div class="chart-wrapper">
                    <div class="chart-area-header">
                        <h5 class="title">
                            <?php echo e(__('Monthly Add Money Chart')); ?>

                        </h5>
                        <a href="<?php echo e(setRoute('admin.add.money.index')); ?>" class="btn--base "> <?php echo e(__('View')); ?></a>
                    </div>
                    <div class="chart-container">
                        <div id="chart1" data-chart_one_data="<?php echo e(json_encode($data['chart_one_data'])); ?>"
                            data-month_day="<?php echo e(json_encode($data['month_day'])); ?>" class="sales-chart"></div>
                    </div>
                </div>
            </div>
            <div class="col-xxl-6 col-xl-6 col-lg-6 mb-15">
                <div class="chart-wrapper">
                    <div class="chart-area-header">
                        <h5 class="title">
                            <?php echo e(__('Monthly Gift Card Chart')); ?>

                        </h5>
                        <a href="<?php echo e(setRoute('admin.gift.card.logs')); ?>" class="btn--base "> <?php echo e(__('View')); ?></a>
                    </div>
                    <div class="chart-container">
                        <div id="chart2" data-chart_two_data="<?php echo e(json_encode($data['chart_two_data'])); ?>"
                            data-month_day="<?php echo e(json_encode($data['month_day'])); ?>" class="sales-chart"></div>
                    </div>
                </div>
            </div>
            <div class="col-xxl-6 col-xl-6 col-lg-6 mb-15">
                <div class="chart-wrapper">
                    <div class="chart-area-header">
                        <h5 class="title">
                            <?php echo e(__('Monthly Mobile Topup')); ?>

                        </h5>
                        <a href="<?php echo e(setRoute('admin.mobile.topup.index')); ?>" class="btn--base "> <?php echo e(__('View')); ?></a>
                    </div>
                    <div class="chart-container">
                        <div id="chart3" data-chart_three_data="<?php echo e(json_encode($data['chart_three_data'])); ?>"
                            data-month_day="<?php echo e(json_encode($data['month_day'])); ?>" class="sales-chart"></div>
                    </div>
                </div>
            </div>
            <div class="col-xxl-6 col-xl-6 col-lg-6 mb-15">
                <div class="chart-wrapper">
                    <div class="chart-area-header">
                        <h5 class="title"><?php echo e(__('User Analytics')); ?></h5>
                    </div>
                    <div class="chart-container">
                        <div id="chart4" data-chart_four_data="<?php echo e(json_encode($data['chart_four_data'])); ?>"
                            class="balance-chart"></div>
                    </div>
                    <div class="chart-area-footer">
                        <div class="chart-btn">
                            <a href="<?php echo e(setRoute('admin.users.index')); ?>"
                                class="btn--base w-100"><?php echo e(__('View Users')); ?></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="table-area mt-15">
        <div class="table-wrapper">
            <div class="table-header">
                <h5 class="title"><?php echo e(__('Latest Transactions')); ?></h5>
            </div>
            <div class="table-responsive">
                <table class="custom-table">
                    <thead>
                        <tr>
                            <th><?php echo e(__('TRX ID')); ?></th>
                            <th><?php echo e(__('Full Name')); ?></th>
                            <th><?php echo e(__('Email')); ?></th>
                            <th><?php echo e(__('Username')); ?></th>
                            <th><?php echo e(__('Phone')); ?></th>
                            <th><?php echo e(__('Amount')); ?></th>
                            <th><?php echo e(__('Gateway')); ?></th>
                            <th><?php echo e(__('Status')); ?></th>
                            <th><?php echo e(__('Time')); ?></th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $data['transactions'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($value->trx_id); ?></td>
                                <td><span><?php echo e($value->user->full_name); ?></span></td>
                                <td><?php echo e($value->user->email); ?></td>
                                <td><?php echo e($value->user->username); ?></td>
                                <td><?php echo e($value->user->full_mobile); ?></td>
                                <td><?php echo e($value->request_amount); ?></td>
                                <td><span class="text--info"><?php echo e($value->gateway_currency->gateway->name); ?></span></td>
                                <?php if($value->status === 1): ?>
                                    <td><span class="badge badge--success"><?php echo e(__('Complete')); ?></span></td>
                                <?php elseif($value->status === 2): ?>
                                    <td><span class="badge badge--warning"><?php echo e(__('Pending')); ?></span></td>
                                <?php else: ?>
                                    <td><span class="badge badge--danger"><?php echo e(__('Canceled')); ?></span></td>
                                <?php endif; ?>
                                <td><?php echo e($value->created_at); ?></td>
                                <td>
                                    <?php echo $__env->make('admin.components.link.info-default', [
                                        'href' => setRoute('admin.add.money.details', $value->id),
                                        'permission' => 'admin.add.money.details',
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        var chart1 = $('#chart1');
        var chart_one_data = chart1.data('chart_one_data');
        var month_day = chart1.data('month_day');
        // apex-chart
        var options = {
            series: [{
                name: "<?php echo e(__('Pending')); ?>",
                color: "#5A5278",
                data: chart_one_data.pending_data
            }, {
                name: "<?php echo e(__('Completed')); ?>",
                color: "#6F6593",
                data: chart_one_data.success_data
            }, {
                name: '<?php echo e(__('Canceled')); ?>',
                color: "#8075AA",
                data: chart_one_data.canceled_data
            }, {
                name: '<?php echo e(__('Hold')); ?>',
                color: "#A192D9",
                data: chart_one_data.hold_data
            }],
            chart: {
                type: 'bar',
                height: 350,
                stacked: true,
                toolbar: {
                    show: false
                },
                zoom: {
                    enabled: true
                }
            },
            responsive: [{
                breakpoint: 480,
                options: {
                    legend: {
                        position: 'bottom',
                        offsetX: -10,
                        offsetY: 0
                    }
                }
            }],
            plotOptions: {
                bar: {
                    horizontal: false,
                    borderRadius: 10
                },
            },
            xaxis: {
                type: 'datetime',
                categories: month_day,
            },
            legend: {
                position: 'bottom',
                offsetX: 40
            },
            fill: {
                opacity: 1
            }
        };

        var chart = new ApexCharts(document.querySelector("#chart1"), options);
        chart.render();

        var chart2 = $('#chart2');
        var chart_two_data = chart2.data('chart_two_data');
        console.log(chart2.data());
        var options = {
            series: [{
                name: "<?php echo e(__('Pending')); ?>",
                color: "#5A5278",
                data: chart_two_data.pending_data
            }, {
                name: "<?php echo e(__('Completed')); ?>",
                color: "#6F6593",
                data: chart_two_data.success_data
            }, {
                name: '<?php echo e(__('Canceled')); ?>',
                color: "#8075AA",
                data: chart_two_data.canceled_data
            }, {
                name: '<?php echo e(__('Hold')); ?>',
                color: "#A192D9",
                data: chart_two_data.hold_data
            }],
            chart: {
                type: 'bar',
                height: 350,
                stacked: true,
                toolbar: {
                    show: false
                },
                zoom: {
                    enabled: true
                }
            },
            responsive: [{
                breakpoint: 480,
                options: {
                    legend: {
                        position: 'bottom',
                        offsetX: -10,
                        offsetY: 0
                    }
                }
            }],
            plotOptions: {
                bar: {
                    horizontal: true,
                    borderRadius: 10
                },
            },
            yaxis: {
                type: 'datetime',
                labels: {
                    format: 'dd/MMM',
                },
                categories: month_day,
            },
            legend: {
                position: 'bottom',
                offsetX: 40
            },
            fill: {
                opacity: 1
            }
        };

        var chart = new ApexCharts(document.querySelector("#chart2"), options);
        chart.render();

        var chart3 = $('#chart3');
        var chart_three_data = chart3.data('chart_three_data');
        var month_day = chart3.data('month_day');
        // apex-chart
        var options = {
            series: [{
                name: "<?php echo e(__('Pending')); ?>",
                color: "#5A5278",
                data: chart_three_data.pending_data
            }, {
                name: "<?php echo e(__('Completed')); ?>",
                color: "#6F6593",
                data: chart_three_data.success_data
            }, {
                name: '<?php echo e(__('Canceled')); ?>',
                color: "#8075AA",
                data: chart_three_data.canceled_data
            }, {
                name: '<?php echo e(__('Hold')); ?>',
                color: "#A192D9",
                data: chart_three_data.hold_data
            }],
            chart: {
                type: 'bar',
                height: 350,
                stacked: true,
                toolbar: {
                    show: false
                },
                zoom: {
                    enabled: true
                }
            },
            responsive: [{
                breakpoint: 480,
                options: {
                    legend: {
                        position: 'bottom',
                        offsetX: -10,
                        offsetY: 0
                    }
                }
            }],
            plotOptions: {
                bar: {
                    horizontal: false,
                    borderRadius: 10
                },
            },
            xaxis: {
                type: 'datetime',
                categories: month_day,
            },
            legend: {
                position: 'bottom',
                offsetX: 40
            },
            fill: {
                opacity: 1
            }
        };

        var chart = new ApexCharts(document.querySelector("#chart3"), options);
        chart.render()

        var chart4 = $('#chart4');
        var chart_four_data = chart4.data('chart_four_data');

        var options = {
            series: chart_four_data,
            chart: {
                width: 350,
                type: 'pie'
            },
            colors: ['#10c469', '#f03d30', '#ff9f43', '#A192D9'],
            labels: ['<?php echo e(__('Active')); ?>', '<?php echo e(__('Banned')); ?>', '<?php echo e(__('Unverified')); ?>', '<?php echo e(__('All')); ?>'],
            responsive: [{
                breakpoint: 1480,
                options: {
                    chart: {
                        width: 280
                    },
                    legend: {
                        position: 'bottom'
                    }
                },
                breakpoint: 1199,
                options: {
                    chart: {
                        width: 380
                    },
                    legend: {
                        position: 'bottom'
                    }
                },
                breakpoint: 575,
                options: {
                    chart: {
                        width: 280
                    },
                    legend: {
                        position: 'bottom'
                    }
                }
            }],
            legend: {
                position: 'bottom'
            },
        };

        var chart = new ApexCharts(document.querySelector("#chart4"), options);
        chart.render();
        // pie-chart
        $(function() {
            $('#chart7').easyPieChart({
                size: 80,
                barColor: '#10c469',
                scaleColor: false,
                lineWidth: 5,
                trackColor: '#10c4695a',
                lineCap: 'circle',
                animate: 3000
            });
        });
        $(function() {
            $('#chart12').easyPieChart({
                size: 80,
                barColor: '#5a5278',
                scaleColor: false,
                lineWidth: 5,
                trackColor: '#5a52785a',
                lineCap: 'circle',
                animate: 3000
            });
        });
        $(function() {
            $('#chart15').easyPieChart({
                size: 80,
                barColor: '#ADDDD0',
                scaleColor: false,
                lineWidth: 5,
                trackColor: '#ADDDD05a',
                lineCap: 'circle',
                animate: 3000
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Payload\resources\views/admin/sections/dashboard/index.blade.php ENDPATH**/ ?>