<?php

namespace Database\Seeders\Admin;

use App\Constants\GlobalConst;
use Illuminate\Database\Seeder;
use App\Models\Admin\UsefulLink;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class UsefulLinkSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $useful_links = array(
            array('id' => '1','type' => 'PRIVACY_POLICY','title' => '{"language":{"en":{"title":"Privacy Policy"},"fr":{"title":"Politique de Confidentialit\\u00e9"},"es":{"title":"Pol\\u00edtica de Privacidad"},"ar":{"title":"\\u0633\\u064a\\u0627\\u0633\\u0629 \\u0627\\u0644\\u062e\\u0635\\u0648\\u0635\\u064a\\u0629"}}}','slug' => 'privacy-policy','url' => 'privacy-policy','content' => '{"language":{"en":{"content":"<p><strong>Introduction<\\/strong> Welcome to PayLoad! We value your trust and are committed to protecting your personal information. This Privacy Policy outlines how we collect, use, disclose, and safeguard your data when you use our platform, including our website, mobile application, and related services. By accessing or using PayLoad, you agree to the terms outlined in this Privacy Policy.<br><strong>Information We Collect<\\/strong> We collect the following types of information:<br>&nbsp;<\\/p><ol style=\\"list-style-type:decimal;\\"><li><strong>Personal Information:<\\/strong> Includes your name, email address, phone number, date of birth, and address provided during account registration or profile updates.<\\/li><li><strong>Financial Information:<\\/strong> Includes payment details and transaction logs when adding funds, purchasing gift cards, or performing mobile top-ups.<\\/li><li><strong>Identity Verification Information:<\\/strong> Includes KYC documents and phone\\/email verification data to confirm your identity and enhance security.<\\/li><li><strong>Device and Usage Information:<\\/strong> Includes device type, IP address, browser type, and activity logs to analyze user behavior and improve our services.<\\/li><\\/ol><p><strong>How We Use Your Information<\\/strong> We use the collected information for the following purposes:<br>&nbsp;<\\/p><ol style=\\"list-style-type:decimal;\\"><li><strong>To Provide Services:<\\/strong> Enable mobile top-ups, gift card purchases, wallet management, and other features.<\\/li><li><strong>Account Management:<\\/strong> Facilitate profile updates, password changes, and 2FA security settings.<\\/li><li><strong>Transaction Tracking:<\\/strong> Maintain logs for mobile recharges, gift card purchases, and wallet deposits for transparency and record-keeping.<\\/li><li><strong>Customer Support:<\\/strong> Address user queries and issues via our support systems.<\\/li><li><strong>Compliance and Security:<\\/strong> Conduct KYC verification, ensure regulatory compliance, and safeguard accounts against unauthorized access.<\\/li><li><strong>Improving User Experience:<\\/strong> Analyze analytics dashboards and user behavior to enhance platform functionality and performance.<\\/li><li><strong>Communication:<\\/strong> Send transaction notifications, promotional emails, and important updates about the platform.<\\/li><\\/ol><p><strong>How We Share Your Information<\\/strong> We do not sell or rent your personal data. However, we may share your information with:<br>&nbsp;<\\/p><ol style=\\"list-style-type:decimal;\\"><li><strong>Service Providers:<\\/strong> Third-party vendors who assist with payment processing, gift card API integrations, and SMS\\/email communications.<\\/li><li><strong>Regulatory Authorities:<\\/strong> Government or regulatory agencies as required by law for compliance purposes.<\\/li><li><strong>Internal Teams:<\\/strong> For admin operations such as user care, admin care, and profit management.<\\/li><li><strong>Third-Party Integrations:<\\/strong> APIs for mobile top-ups, gift cards, and payment gateways when necessary to fulfill transactions.<\\/li><\\/ol><p><strong>Data Retention<\\/strong> We retain your data only as long as it is necessary to fulfill the purposes outlined in this policy or comply with legal obligations. Transaction logs and financial records may be kept for auditing and compliance purposes.<br><strong>Security Measures<\\/strong> We implement robust security measures to protect your data, including:<br>&nbsp;<\\/p><ol style=\\"list-style-type:decimal;\\"><li><strong>Encryption:<\\/strong> Encrypt sensitive information during transmission and storage.<\\/li><li><strong>2FA Security:<\\/strong> Enable two-factor authentication for user and admin accounts.<\\/li><li><strong>Access Controls:<\\/strong> Restrict access to sensitive data to authorized personnel only.<\\/li><li><strong>Regular Audits:<\\/strong> Conduct routine checks and updates to ensure platform security.<\\/li><\\/ol><p><strong>User Rights<\\/strong> As a PayLoad user, you have the following rights:<br>&nbsp;<\\/p><ol style=\\"list-style-type:decimal;\\"><li><strong>Access Your Data:<\\/strong> Request a copy of the personal data we hold about you.<\\/li><li><strong>Update Your Data:<\\/strong> Correct or update your personal information via the profile update feature.<\\/li><li><strong>Delete Your Data:<\\/strong> Request deletion of your account and associated data, subject to regulatory compliance.<\\/li><li><strong>Data Portability:<\\/strong> Obtain your data in a structured, machine-readable format.<\\/li><li><strong>Opt-Out:<\\/strong> Unsubscribe from promotional emails and communications.<\\/li><\\/ol><p><strong>Cookie Policy<\\/strong> Our platform uses cookies to enhance your experience. These include:<br>&nbsp;french<\\/p><ol style=\\"list-style-type:decimal;\\"><li><strong>Essential Cookies:<\\/strong> Necessary for platform functionality.<\\/li><li><strong>Analytical Cookies:<\\/strong> Help us understand user behavior and improve services.<\\/li><li><strong>GDPR Compliance:<\\/strong> Users can manage their cookie preferences via the cookie settings page.<\\/li><\\/ol><p><strong>Third-Party Links<\\/strong> PayLoad may contain links to external websites or services. We are not responsible for their privacy practices or content. Please review their privacy policies before engaging with them.<br><strong>International Data Transfers<\\/strong> If you access PayLoad from outside our operational regions, your data may be transferred to and processed in countries with different data protection laws. We ensure such transfers comply with applicable regulations.<br><strong>Children\'s Privacy<\\/strong> PayLoad is not intended for individuals under the age of 18. We do not knowingly collect personal information from children. If you believe a child has provided us with their data, contact us to have it removed.<br><strong>Changes to This Privacy Policy<\\/strong> We may update this Privacy Policy from time to time. Changes will be posted on this page with a revised effective date. Please review it periodically to stay informed about how we protect your information.<\\/p>"},"fr":{"content":"<p><strong>Introduction<\\/strong><br>Bienvenue sur PayLoad ! Nous attachons une grande importance \\u00e0 votre confiance et nous nous engageons \\u00e0 prot\\u00e9ger vos informations personnelles. Cette politique de confidentialit\\u00e9 d\\u00e9crit comment nous collectons, utilisons, divulguons et prot\\u00e9geons vos donn\\u00e9es lorsque vous utilisez notre plateforme, y compris notre site web, notre application mobile et nos services associ\\u00e9s. En acc\\u00e9dant \\u00e0 PayLoad ou en l\\u2019utilisant, vous acceptez les termes \\u00e9nonc\\u00e9s dans cette politique de confidentialit\\u00e9.<\\/p><p><strong>Informations que Nous Collectons<\\/strong><br>Nous collectons les types d\'informations suivants :<\\/p><ul><li><strong>Informations Personnelles<\\/strong> : Comprend votre nom, adresse e-mail, num\\u00e9ro de t\\u00e9l\\u00e9phone, date de naissance et adresse fournis lors de l\\u2019inscription ou des mises \\u00e0 jour de profil.<\\/li><li><strong>Informations Financi\\u00e8res<\\/strong> : D\\u00e9tails de paiement et journaux des transactions li\\u00e9s aux d\\u00e9p\\u00f4ts, achats de cartes-cadeaux ou recharges mobiles.<\\/li><li><strong>V\\u00e9rification d\\u2019Identit\\u00e9<\\/strong> : Documents KYC et donn\\u00e9es de v\\u00e9rification de t\\u00e9l\\u00e9phone\\/e-mail pour confirmer votre identit\\u00e9 et renforcer la s\\u00e9curit\\u00e9.<\\/li><li><strong>Informations sur l\\u2019Appareil et l\\u2019Utilisation<\\/strong> : Type d\\u2019appareil, adresse IP, type de navigateur et journaux d\\u2019activit\\u00e9 pour analyser le comportement des utilisateurs et am\\u00e9liorer nos services.<\\/li><\\/ul><p><strong>Comment Nous Utilisons Vos Informations<\\/strong><br>Nous utilisons les informations collect\\u00e9es pour :<\\/p><ul><li><strong>Fournir des Services<\\/strong> : Activer les recharges mobiles, les achats de cartes-cadeaux, la gestion de portefeuille et d\\u2019autres fonctionnalit\\u00e9s.<\\/li><li><strong>Gestion des Comptes<\\/strong> : Faciliter les mises \\u00e0 jour de profil, changements de mot de passe et param\\u00e8tres de s\\u00e9curit\\u00e9 2FA.<\\/li><li><strong>Suivi des Transactions<\\/strong> : Maintenir des journaux pour les recharges, achats de cartes-cadeaux et d\\u00e9p\\u00f4ts de portefeuille pour assurer la transparence.<\\/li><li><strong>Support Client<\\/strong> : R\\u00e9pondre aux questions et probl\\u00e8mes via nos syst\\u00e8mes de support.<\\/li><li><strong>Conformit\\u00e9 et S\\u00e9curit\\u00e9<\\/strong> : Effectuer des v\\u00e9rifications KYC, assurer la conformit\\u00e9 r\\u00e9glementaire et prot\\u00e9ger les comptes contre tout acc\\u00e8s non autoris\\u00e9.<\\/li><li><strong>Am\\u00e9lioration de l\\u2019Exp\\u00e9rience Utilisateur<\\/strong> : Analyser les tableaux de bord analytiques et le comportement des utilisateurs pour optimiser les fonctionnalit\\u00e9s de la plateforme.<\\/li><li><strong>Communication<\\/strong> : Envoyer des notifications de transaction, des e-mails promotionnels et des mises \\u00e0 jour importantes sur la plateforme.<\\/li><\\/ul><p><strong>Comment Nous Partageons Vos Informations<\\/strong><br>Nous ne vendons ni ne louons vos donn\\u00e9es personnelles. Cependant, nous pouvons partager vos informations avec :<\\/p><ul><li><strong>Fournisseurs de Services<\\/strong> : Des prestataires tiers qui aident \\u00e0 traiter les paiements, l\'int\\u00e9gration API des cartes-cadeaux, et les communications par SMS\\/email.<\\/li><li><strong>Autorit\\u00e9s de R\\u00e9gulation<\\/strong> : Des agences gouvernementales ou de r\\u00e9gulation comme requis par la loi pour des fins de conformit\\u00e9.<\\/li><li><strong>\\u00c9quipes Internes<\\/strong> : Pour les op\\u00e9rations administratives telles que la gestion des utilisateurs, des administrateurs et des profits.<\\/li><li><strong>Int\\u00e9grations Tiers<\\/strong> : Des API pour les recharges mobiles, cartes-cadeaux et passerelles de paiement lorsque cela est n\\u00e9cessaire pour accomplir des transactions.<\\/li><\\/ul><p><strong>Conservation des Donn\\u00e9es<\\/strong><br>Nous conservons vos donn\\u00e9es uniquement aussi longtemps que n\\u00e9cessaire pour remplir les objectifs d\\u00e9crits dans cette politique ou pour nous conformer aux obligations l\\u00e9gales. Les journaux de transactions et les enregistrements financiers peuvent \\u00eatre conserv\\u00e9s \\u00e0 des fins d\\u2019audit et de conformit\\u00e9.<\\/p><p><strong>Mesures de S\\u00e9curit\\u00e9<\\/strong><br>Nous mettons en place des mesures de s\\u00e9curit\\u00e9 robustes pour prot\\u00e9ger vos donn\\u00e9es, notamment :<\\/p><ul><li><strong>Cryptage<\\/strong> : Chiffrer les informations sensibles lors de la transmission et du stockage.<\\/li><li><strong>S\\u00e9curit\\u00e9 2FA<\\/strong> : Activer l\\u2019authentification \\u00e0 deux facteurs pour les comptes utilisateurs et administrateurs.<\\/li><li><strong>Contr\\u00f4les d\'Acc\\u00e8s<\\/strong> : Limiter l\'acc\\u00e8s aux donn\\u00e9es sensibles uniquement au personnel autoris\\u00e9.<\\/li><li><strong>Audits R\\u00e9guliers<\\/strong> : Effectuer des contr\\u00f4les et des mises \\u00e0 jour r\\u00e9guliers pour assurer la s\\u00e9curit\\u00e9 de la plateforme.<\\/li><\\/ul><p><strong>Droits des Utilisateurs<\\/strong><br>En tant qu\'utilisateur de PayLoad, vous avez les droits suivants :<\\/p><ul><li><strong>Acc\\u00e9der \\u00e0 Vos Donn\\u00e9es<\\/strong> : Demander une copie des donn\\u00e9es personnelles que nous d\\u00e9tenons \\u00e0 votre sujet.<\\/li><li><strong>Mettre \\u00e0 Jour Vos Donn\\u00e9es<\\/strong> : Corriger ou mettre \\u00e0 jour vos informations personnelles via la fonctionnalit\\u00e9 de mise \\u00e0 jour du profil.<\\/li><li><strong>Supprimer Vos Donn\\u00e9es<\\/strong> : Demander la suppression de votre compte et des donn\\u00e9es associ\\u00e9es, sous r\\u00e9serve de conformit\\u00e9 r\\u00e9glementaire.<\\/li><li><strong>Portabilit\\u00e9 des Donn\\u00e9es<\\/strong> : Obtenez vos donn\\u00e9es dans un format structur\\u00e9 et lisible par machine.<\\/li><li><strong>Se D\\u00e9sabonner<\\/strong> : Se d\\u00e9sinscrire des e-mails et communications promotionnelles.<\\/li><\\/ul><p><strong>Politique de Cookies<\\/strong><br>Notre plateforme utilise des cookies pour am\\u00e9liorer votre exp\\u00e9rience. Ceux-ci comprennent :<\\/p><ul><li><strong>Cookies Essentiels<\\/strong> : N\\u00e9cessaires pour le fonctionnement de la plateforme.<\\/li><li><strong>Cookies Analytiques<\\/strong> : Aident \\u00e0 comprendre le comportement des utilisateurs et \\u00e0 am\\u00e9liorer les services.<\\/li><li><strong>Conformit\\u00e9 au RGPD<\\/strong> : Les utilisateurs peuvent g\\u00e9rer leurs pr\\u00e9f\\u00e9rences de cookies via la page des param\\u00e8tres des cookies.<\\/li><\\/ul><p><strong>Liens Tiers<\\/strong><br>PayLoad peut contenir des liens vers des sites web ou services externes. Nous ne sommes pas responsables de leurs pratiques en mati\\u00e8re de confidentialit\\u00e9 ou de leur contenu. Veuillez examiner leurs politiques de confidentialit\\u00e9 avant d\'interagir avec eux.<\\/p><p><strong>Transferts Internationaux de Donn\\u00e9es<\\/strong><br>Si vous acc\\u00e9dez \\u00e0 PayLoad depuis une r\\u00e9gion en dehors de nos r\\u00e9gions op\\u00e9rationnelles, vos donn\\u00e9es peuvent \\u00eatre transf\\u00e9r\\u00e9es et trait\\u00e9es dans des pays ayant des lois de protection des donn\\u00e9es diff\\u00e9rentes. Nous nous assurons que ces transferts respectent les r\\u00e9glementations applicables.<\\/p><p><strong>Confidentialit\\u00e9 des Enfants<\\/strong><br>PayLoad n\'est pas destin\\u00e9 aux personnes de moins de 18 ans. Nous ne collectons pas sciemment des informations personnelles aupr\\u00e8s des enfants. Si vous pensez qu\'un enfant nous a fourni ses donn\\u00e9es, contactez-nous pour qu\'elles soient supprim\\u00e9es.<\\/p><p><strong>Modifications de cette Politique de Confidentialit\\u00e9<\\/strong><br>Nous pouvons mettre \\u00e0 jour cette Politique de Confidentialit\\u00e9 de temps en temps. Les changements seront publi\\u00e9s sur cette page avec une date de mise en vigueur r\\u00e9vis\\u00e9e. Veuillez la consulter p\\u00e9riodiquement pour rester inform\\u00e9 sur la mani\\u00e8re dont nous prot\\u00e9geons vos informations.<\\/p>"},"es":{"content":"<p><strong>Introducci\\u00f3n<\\/strong><br>\\u00a1Bienvenido a PayLoad! Valoramos su confianza y estamos comprometidos con la protecci\\u00f3n de su informaci\\u00f3n personal. Esta Pol\\u00edtica de Privacidad describe c\\u00f3mo recopilamos, usamos, divulgamos y protegemos sus datos cuando utiliza nuestra plataforma, incluidos nuestro sitio web, aplicaci\\u00f3n m\\u00f3vil y servicios relacionados. Al acceder o utilizar PayLoad, acepta los t\\u00e9rminos establecidos en esta Pol\\u00edtica de Privacidad.<\\/p><p><strong>Informaci\\u00f3n que Recopilamos<\\/strong><br>Recopilamos los siguientes tipos de informaci\\u00f3n:<\\/p><ul><li><strong>Informaci\\u00f3n Personal<\\/strong>: Incluye su nombre, direcci\\u00f3n de correo electr\\u00f3nico, n\\u00famero de tel\\u00e9fono, fecha de nacimiento y direcci\\u00f3n proporcionados durante el registro o actualizaciones de perfil.<\\/li><li><strong>Informaci\\u00f3n Financiera<\\/strong>: Detalles de pago y registros de transacciones al agregar fondos, comprar tarjetas de regalo o realizar recargas m\\u00f3viles.<\\/li><li><strong>Verificaci\\u00f3n de Identidad<\\/strong>: Documentos KYC y datos de verificaci\\u00f3n de tel\\u00e9fono\\/correo electr\\u00f3nico para confirmar su identidad y mejorar la seguridad.<\\/li><li><strong>Informaci\\u00f3n del Dispositivo y Uso<\\/strong>: Tipo de dispositivo, direcci\\u00f3n IP, tipo de navegador y registros de actividad para analizar el comportamiento de los usuarios y mejorar nuestros servicios.<\\/li><\\/ul><p><strong>C\\u00f3mo Usamos Su Informaci\\u00f3n<\\/strong><br>Usamos la informaci\\u00f3n recopilada para:<\\/p><ul><li><strong>Proveer Servicios<\\/strong>: Habilitar recargas m\\u00f3viles, compras de tarjetas de regalo, gesti\\u00f3n de billetera y otras funciones.<\\/li><li><strong>Gesti\\u00f3n de Cuenta<\\/strong>: Facilitar actualizaciones de perfil, cambios de contrase\\u00f1a y configuraciones de seguridad 2FA.<\\/li><li><strong>Seguimiento de Transacciones<\\/strong>: Mantener registros de recargas m\\u00f3viles, compras de tarjetas de regalo y dep\\u00f3sitos de billetera para mayor transparencia.<\\/li><li><strong>Atenci\\u00f3n al Cliente<\\/strong>: Responder a consultas y problemas a trav\\u00e9s de nuestros sistemas de soporte.<\\/li><li><strong>Cumplimiento y Seguridad<\\/strong>: Realizar verificaciones KYC, garantizar el cumplimiento normativo y proteger las cuentas contra accesos no autorizados.<\\/li><li><strong>Mejorar la Experiencia del Usuario<\\/strong>: Analizar paneles anal\\u00edticos y comportamiento de usuarios para mejorar la funcionalidad de la plataforma.<\\/li><li><strong>Comunicaci\\u00f3n<\\/strong>: Enviar notificaciones de transacciones, correos promocionales y actualizaciones importantes sobre la plataforma.<\\/li><\\/ul><p><strong>C\\u00f3mo Compartimos Su Informaci\\u00f3n<\\/strong><br>No vendemos ni alquilamos sus datos personales. Sin embargo, podemos compartir su informaci\\u00f3n con:<\\/p><ul><li><strong>Proveedores de Servicios<\\/strong>: Proveedores externos que ayudan con el procesamiento de pagos, la integraci\\u00f3n de API de tarjetas de regalo y las comunicaciones por SMS\\/correo electr\\u00f3nico.<\\/li><li><strong>Autoridades Regulatorias<\\/strong>: Agencias gubernamentales o reguladoras seg\\u00fan lo exija la ley para fines de cumplimiento.<\\/li><li><strong>Equipos Internos<\\/strong>: Para operaciones administrativas como la gesti\\u00f3n de usuarios, administraci\\u00f3n y gesti\\u00f3n de ganancias.<\\/li><li><strong>Integraciones de Terceros<\\/strong>: APIs para recargas m\\u00f3viles, tarjetas de regalo y pasarelas de pago cuando sea necesario para cumplir con las transacciones.<\\/li><\\/ul><p><strong>Conservaci\\u00f3n de Datos<\\/strong><br>Conservamos sus datos solo durante el tiempo necesario para cumplir con los fines descritos en esta pol\\u00edtica o para cumplir con obligaciones legales. Los registros de transacciones y los documentos financieros pueden conservarse con fines de auditor\\u00eda y cumplimiento.<\\/p><p><strong>Medidas de Seguridad<\\/strong><br>Implementamos medidas de seguridad robustas para proteger sus datos, incluyendo:<\\/p><ul><li><strong>Cifrado<\\/strong>: Cifrado de informaci\\u00f3n sensible durante la transmisi\\u00f3n y el almacenamiento.<\\/li><li><strong>Seguridad 2FA<\\/strong>: Habilitaci\\u00f3n de la autenticaci\\u00f3n de dos factores para cuentas de usuario y administrador.<\\/li><li><strong>Controles de Acceso<\\/strong>: Restringir el acceso a datos sensibles solo al personal autorizado.<\\/li><li><strong>Auditor\\u00edas Regulares<\\/strong>: Realizaci\\u00f3n de revisiones peri\\u00f3dicas para asegurar la seguridad de la plataforma.<\\/li><\\/ul><p><strong>Derechos de los Usuarios<\\/strong><br>Como usuario de PayLoad, tiene los siguientes derechos:<\\/p><ul><li><strong>Acceder a Sus Datos<\\/strong>: Solicitar una copia de los datos personales que tenemos sobre usted.<\\/li><li><strong>Actualizar Sus Datos<\\/strong>: Corregir o actualizar su informaci\\u00f3n personal a trav\\u00e9s de la funci\\u00f3n de actualizaci\\u00f3n del perfil.<\\/li><li><strong>Eliminar Sus Datos<\\/strong>: Solicitar la eliminaci\\u00f3n de su cuenta y los datos asociados, sujeto al cumplimiento regulatorio.<\\/li><li><strong>Portabilidad de los Datos<\\/strong>: Obtener sus datos en un formato estructurado y legible por m\\u00e1quina.<\\/li><li><strong>Cancelar Suscripciones<\\/strong>: Darse de baja de correos electr\\u00f3nicos promocionales y comunicaciones.<\\/li><\\/ul><p><strong>Pol\\u00edtica de Cookies<\\/strong><br>Nuestra plataforma utiliza cookies para mejorar su experiencia. Estas incluyen:<\\/p><ul><li><strong>Cookies Esenciales<\\/strong>: Necesarias para la funcionalidad de la plataforma.<\\/li><li><strong>Cookies Anal\\u00edticas<\\/strong>: Ayudan a comprender el comportamiento de los usuarios y a mejorar los servicios.<\\/li><li><strong>Cumplimiento con GDPR<\\/strong>: Los usuarios pueden gestionar sus preferencias de cookies a trav\\u00e9s de la p\\u00e1gina de configuraci\\u00f3n de cookies.<\\/li><\\/ul><p><strong>Enlaces de Terceros<\\/strong><br>PayLoad puede contener enlaces a sitios web o servicios externos. No somos responsables de sus pr\\u00e1cticas de privacidad ni de su contenido. Por favor, revise sus pol\\u00edticas de privacidad antes de interactuar con ellos.<\\/p><p><strong>Transferencias Internacionales de Datos<\\/strong><br>Si accede a PayLoad desde fuera de nuestras regiones operativas, sus datos pueden ser transferidos y procesados en pa\\u00edses con leyes de protecci\\u00f3n de datos diferentes. Nos aseguramos de que dichas transferencias cumplan con las regulaciones aplicables.<\\/p><p><strong>Privacidad de los Ni\\u00f1os<\\/strong><br>PayLoad no est\\u00e1 destinado a personas menores de 18 a\\u00f1os. No recopilamos conscientemente informaci\\u00f3n personal de ni\\u00f1os. Si cree que un ni\\u00f1o nos ha proporcionado sus datos, comun\\u00edquese con nosotros para eliminarlos.<\\/p><p><strong>Cambios en Esta Pol\\u00edtica de Privacidad<\\/strong><br>Podemos actualizar esta Pol\\u00edtica de Privacidad de vez en cuando. Los cambios se publicar\\u00e1n en esta p\\u00e1gina con una nueva fecha de efectividad. Por favor, rev\\u00edselo peri\\u00f3dicamente para mantenerse informado sobre c\\u00f3mo protegemos su informaci\\u00f3n.<\\/p>"},"ar":{"content":"<p><strong>\\u0627\\u0644\\u0645\\u0642\\u062f\\u0645\\u0629<\\/strong><br>\\u0645\\u0631\\u062d\\u0628\\u064b\\u0627 \\u0628\\u0643 \\u0641\\u064a PayLoad! \\u0646\\u062d\\u0646 \\u0646\\u0642\\u062f\\u0631 \\u062b\\u0642\\u062a\\u0643 \\u0648\\u0645\\u0644\\u062a\\u0632\\u0645\\u0648\\u0646 \\u0628\\u062d\\u0645\\u0627\\u064a\\u0629 \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a\\u0643 \\u0627\\u0644\\u0634\\u062e\\u0635\\u064a\\u0629. \\u062a\\u0648\\u0636\\u062d \\u0633\\u064a\\u0627\\u0633\\u0629 \\u0627\\u0644\\u062e\\u0635\\u0648\\u0635\\u064a\\u0629 \\u0647\\u0630\\u0647 \\u0643\\u064a\\u0641\\u064a\\u0629 \\u062c\\u0645\\u0639 \\u0648\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0648\\u0645\\u0634\\u0627\\u0631\\u0643\\u0629 \\u0648\\u062d\\u0645\\u0627\\u064a\\u0629 \\u0628\\u064a\\u0627\\u0646\\u0627\\u062a\\u0643 \\u0639\\u0646\\u062f \\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0645\\u0646\\u0635\\u062a\\u0646\\u0627\\u060c \\u0628\\u0645\\u0627 \\u0641\\u064a \\u0630\\u0644\\u0643 \\u0645\\u0648\\u0642\\u0639\\u0646\\u0627 \\u0627\\u0644\\u0625\\u0644\\u0643\\u062a\\u0631\\u0648\\u0646\\u064a\\u060c \\u062a\\u0637\\u0628\\u064a\\u0642\\u0646\\u0627\\u060c \\u0648\\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u0645\\u0631\\u062a\\u0628\\u0637\\u0629. \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645\\u0643 PayLoad\\u060c \\u0641\\u0625\\u0646\\u0643 \\u062a\\u0648\\u0627\\u0641\\u0642 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0634\\u0631\\u0648\\u0637 \\u0627\\u0644\\u0648\\u0627\\u0631\\u062f\\u0629 \\u0641\\u064a \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0633\\u064a\\u0627\\u0633\\u0629.<\\/p><p><strong>\\u0627\\u0644\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0627\\u0644\\u062a\\u064a \\u0646\\u062c\\u0645\\u0639\\u0647\\u0627<\\/strong><br>\\u0646\\u062c\\u0645\\u0639 \\u0627\\u0644\\u0623\\u0646\\u0648\\u0627\\u0639 \\u0627\\u0644\\u062a\\u0627\\u0644\\u064a\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a:<\\/p><ul><li><strong>\\u0627\\u0644\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0627\\u0644\\u0634\\u062e\\u0635\\u064a\\u0629<\\/strong>: \\u062a\\u0634\\u0645\\u0644 \\u0627\\u0644\\u0627\\u0633\\u0645\\u060c \\u0639\\u0646\\u0648\\u0627\\u0646 \\u0627\\u0644\\u0628\\u0631\\u064a\\u062f \\u0627\\u0644\\u0625\\u0644\\u0643\\u062a\\u0631\\u0648\\u0646\\u064a\\u060c \\u0631\\u0642\\u0645 \\u0627\\u0644\\u0647\\u0627\\u062a\\u0641\\u060c \\u062a\\u0627\\u0631\\u064a\\u062e \\u0627\\u0644\\u0645\\u064a\\u0644\\u0627\\u062f\\u060c \\u0648\\u0627\\u0644\\u0639\\u0646\\u0648\\u0627\\u0646 \\u0627\\u0644\\u0630\\u064a \\u064a\\u062a\\u0645 \\u062a\\u0642\\u062f\\u064a\\u0645\\u0647 \\u0623\\u062b\\u0646\\u0627\\u0621 \\u0627\\u0644\\u062a\\u0633\\u062c\\u064a\\u0644 \\u0623\\u0648 \\u062a\\u062d\\u062f\\u064a\\u062b \\u0627\\u0644\\u0645\\u0644\\u0641 \\u0627\\u0644\\u0634\\u062e\\u0635\\u064a.<\\/li><li><strong>\\u0627\\u0644\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0627\\u0644\\u0645\\u0627\\u0644\\u064a\\u0629<\\/strong>: \\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0648\\u0633\\u062c\\u0644\\u0627\\u062a \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0639\\u0646\\u062f \\u0625\\u0636\\u0627\\u0641\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644\\u060c \\u0634\\u0631\\u0627\\u0621 \\u0628\\u0637\\u0627\\u0642\\u0627\\u062a \\u0627\\u0644\\u0647\\u062f\\u0627\\u064a\\u0627\\u060c \\u0623\\u0648 \\u0634\\u062d\\u0646 \\u0627\\u0644\\u0647\\u0648\\u0627\\u062a\\u0641 \\u0627\\u0644\\u0645\\u062d\\u0645\\u0648\\u0644\\u0629.<\\/li><li><strong>\\u062a\\u0648\\u062b\\u064a\\u0642 \\u0627\\u0644\\u0647\\u0648\\u064a\\u0629<\\/strong>: \\u0645\\u0633\\u062a\\u0646\\u062f\\u0627\\u062a KYC \\u0648\\u0628\\u064a\\u0627\\u0646\\u0627\\u062a \\u0627\\u0644\\u062a\\u062d\\u0642\\u0642 \\u0645\\u0646 \\u0627\\u0644\\u0647\\u0627\\u062a\\u0641\\/\\u0627\\u0644\\u0628\\u0631\\u064a\\u062f \\u0627\\u0644\\u0625\\u0644\\u0643\\u062a\\u0631\\u0648\\u0646\\u064a \\u0644\\u062a\\u0623\\u0643\\u064a\\u062f \\u0627\\u0644\\u0647\\u0648\\u064a\\u0629 \\u0648\\u062a\\u0639\\u0632\\u064a\\u0632 \\u0627\\u0644\\u0623\\u0645\\u0627\\u0646.<\\/li><li><strong>\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0627\\u0644\\u062c\\u0647\\u0627\\u0632 \\u0648\\u0627\\u0644\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645<\\/strong>: \\u0646\\u0648\\u0639 \\u0627\\u0644\\u062c\\u0647\\u0627\\u0632\\u060c \\u0639\\u0646\\u0648\\u0627\\u0646 IP\\u060c \\u0646\\u0648\\u0639 \\u0627\\u0644\\u0645\\u062a\\u0635\\u0641\\u062d\\u060c \\u0648\\u0633\\u062c\\u0644\\u0627\\u062a \\u0627\\u0644\\u0646\\u0634\\u0627\\u0637 \\u0644\\u062a\\u062d\\u0644\\u064a\\u0644 \\u0633\\u0644\\u0648\\u0643 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645 \\u0648\\u062a\\u062d\\u0633\\u064a\\u0646 \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a.<\\/li><\\/ul><p><strong>\\u0643\\u064a\\u0641\\u064a\\u0629 \\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a\\u0643<\\/strong><br>\\u0646\\u0633\\u062a\\u062e\\u062f\\u0645 \\u0627\\u0644\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0627\\u0644\\u062a\\u064a \\u0646\\u062c\\u0645\\u0639\\u0647\\u0627 \\u0644\\u0644\\u0623\\u063a\\u0631\\u0627\\u0636 \\u0627\\u0644\\u062a\\u0627\\u0644\\u064a\\u0629:<\\/p><ul><li><strong>\\u062a\\u0642\\u062f\\u064a\\u0645 \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a<\\/strong>: \\u062a\\u0645\\u0643\\u064a\\u0646 \\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u0634\\u062d\\u0646 \\u0627\\u0644\\u0647\\u0648\\u0627\\u062a\\u0641\\u060c \\u0634\\u0631\\u0627\\u0621 \\u0628\\u0637\\u0627\\u0642\\u0627\\u062a \\u0627\\u0644\\u0647\\u062f\\u0627\\u064a\\u0627\\u060c \\u0625\\u062f\\u0627\\u0631\\u0629 \\u0627\\u0644\\u0645\\u062d\\u0627\\u0641\\u0638\\u060c \\u0648\\u063a\\u064a\\u0631\\u0647\\u0627 \\u0645\\u0646 \\u0627\\u0644\\u0645\\u064a\\u0632\\u0627\\u062a.<\\/li><li><strong>\\u0625\\u062f\\u0627\\u0631\\u0629 \\u0627\\u0644\\u062d\\u0633\\u0627\\u0628\\u0627\\u062a<\\/strong>: \\u062a\\u0633\\u0647\\u064a\\u0644 \\u062a\\u062d\\u062f\\u064a\\u062b\\u0627\\u062a \\u0627\\u0644\\u0645\\u0644\\u0641 \\u0627\\u0644\\u0634\\u062e\\u0635\\u064a\\u060c \\u062a\\u063a\\u064a\\u064a\\u0631\\u0627\\u062a \\u0643\\u0644\\u0645\\u0629 \\u0627\\u0644\\u0645\\u0631\\u0648\\u0631\\u060c \\u0648\\u0625\\u0639\\u062f\\u0627\\u062f\\u0627\\u062a \\u0627\\u0644\\u0645\\u0635\\u0627\\u062f\\u0642\\u0629 \\u0627\\u0644\\u062b\\u0646\\u0627\\u0626\\u064a\\u0629.<\\/li><li><strong>\\u062a\\u062a\\u0628\\u0639 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a<\\/strong>: \\u0627\\u0644\\u062d\\u0641\\u0627\\u0638 \\u0639\\u0644\\u0649 \\u0633\\u062c\\u0644\\u0627\\u062a \\u0627\\u0644\\u0634\\u062d\\u0646\\u060c \\u0645\\u0634\\u062a\\u0631\\u064a\\u0627\\u062a \\u0628\\u0637\\u0627\\u0642\\u0627\\u062a \\u0627\\u0644\\u0647\\u062f\\u0627\\u064a\\u0627\\u060c \\u0648\\u0625\\u064a\\u062f\\u0627\\u0639\\u0627\\u062a \\u0627\\u0644\\u0645\\u062d\\u0627\\u0641\\u0638 \\u0644\\u0636\\u0645\\u0627\\u0646 \\u0627\\u0644\\u0634\\u0641\\u0627\\u0641\\u064a\\u0629.<\\/li><li><strong>\\u062f\\u0639\\u0645 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u0621<\\/strong>: \\u0645\\u0639\\u0627\\u0644\\u062c\\u0629 \\u0627\\u0633\\u062a\\u0641\\u0633\\u0627\\u0631\\u0627\\u062a \\u0648\\u0645\\u0634\\u0643\\u0644\\u0627\\u062a \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646 \\u0639\\u0628\\u0631 \\u0623\\u0646\\u0638\\u0645\\u0629 \\u0627\\u0644\\u062f\\u0639\\u0645.<\\/li><li><strong>\\u0627\\u0644\\u0627\\u0645\\u062a\\u062b\\u0627\\u0644 \\u0648\\u0627\\u0644\\u0623\\u0645\\u0627\\u0646<\\/strong>: \\u0625\\u062c\\u0631\\u0627\\u0621 \\u0627\\u0644\\u062a\\u062d\\u0642\\u0642 \\u0645\\u0646 KYC \\u0648\\u0636\\u0645\\u0627\\u0646 \\u0627\\u0644\\u0627\\u0645\\u062a\\u062b\\u0627\\u0644 \\u0644\\u0644\\u0648\\u0627\\u0626\\u062d \\u0648\\u062d\\u0645\\u0627\\u064a\\u0629 \\u0627\\u0644\\u062d\\u0633\\u0627\\u0628\\u0627\\u062a \\u0645\\u0646 \\u0627\\u0644\\u0648\\u0635\\u0648\\u0644 \\u063a\\u064a\\u0631 \\u0627\\u0644\\u0645\\u0635\\u0631\\u062d \\u0628\\u0647.<\\/li><li><strong>\\u062a\\u062d\\u0633\\u064a\\u0646 \\u062a\\u062c\\u0631\\u0628\\u0629 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645<\\/strong>: \\u062a\\u062d\\u0644\\u064a\\u0644 \\u0627\\u0644\\u0628\\u064a\\u0627\\u0646\\u0627\\u062a \\u0648\\u0633\\u0644\\u0648\\u0643 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646 \\u0644\\u062a\\u062d\\u0633\\u064a\\u0646 \\u0648\\u0638\\u0627\\u0626\\u0641 \\u0627\\u0644\\u0645\\u0646\\u0635\\u0629.<\\/li><li><strong>\\u0627\\u0644\\u0627\\u062a\\u0635\\u0627\\u0644\\u0627\\u062a<\\/strong>: \\u0625\\u0631\\u0633\\u0627\\u0644 \\u0625\\u0634\\u0639\\u0627\\u0631\\u0627\\u062a \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a\\u060c \\u0631\\u0633\\u0627\\u0626\\u0644 \\u0627\\u0644\\u0628\\u0631\\u064a\\u062f \\u0627\\u0644\\u0625\\u0644\\u0643\\u062a\\u0631\\u0648\\u0646\\u064a \\u0627\\u0644\\u062a\\u0631\\u0648\\u064a\\u062c\\u064a\\u0629\\u060c \\u0648\\u0627\\u0644\\u062a\\u062d\\u062f\\u064a\\u062b\\u0627\\u062a \\u0627\\u0644\\u0647\\u0627\\u0645\\u0629 \\u062d\\u0648\\u0644 \\u0627\\u0644\\u0645\\u0646\\u0635\\u0629.<\\/li><\\/ul><p><strong>\\u0643\\u064a\\u0641\\u064a\\u0629 \\u0645\\u0634\\u0627\\u0631\\u0643\\u0629 \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a\\u0643<\\/strong><br>\\u0646\\u062d\\u0646 \\u0644\\u0627 \\u0646\\u0628\\u064a\\u0639 \\u0623\\u0648 \\u0646\\u0624\\u062c\\u0631 \\u0628\\u064a\\u0627\\u0646\\u0627\\u062a\\u0643 \\u0627\\u0644\\u0634\\u062e\\u0635\\u064a\\u0629. \\u0648\\u0645\\u0639 \\u0630\\u0644\\u0643\\u060c \\u0642\\u062f \\u0646\\u0634\\u0627\\u0631\\u0643 \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a\\u0643 \\u0645\\u0639:<\\/p><ul><li><strong>\\u0645\\u0632\\u0648\\u062f\\u064a \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a<\\/strong>: \\u0645\\u0632\\u0648\\u062f\\u064a \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u062e\\u0627\\u0631\\u062c\\u064a\\u064a\\u0646 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u064a\\u0633\\u0627\\u0639\\u062f\\u0648\\u0646 \\u0641\\u064a \\u0645\\u0639\\u0627\\u0644\\u062c\\u0629 \\u0627\\u0644\\u0645\\u062f\\u0641\\u0648\\u0639\\u0627\\u062a\\u060c \\u062a\\u0643\\u0627\\u0645\\u0644 API \\u0644\\u0628\\u0637\\u0627\\u0642\\u0627\\u062a \\u0627\\u0644\\u0647\\u062f\\u0627\\u064a\\u0627\\u060c \\u0648\\u0627\\u0644\\u062a\\u0648\\u0627\\u0635\\u0644 \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0631\\u0633\\u0627\\u0626\\u0644 \\u0627\\u0644\\u0646\\u0635\\u064a\\u0629 \\u0627\\u0644\\u0642\\u0635\\u064a\\u0631\\u0629\\/\\u0627\\u0644\\u0628\\u0631\\u064a\\u062f \\u0627\\u0644\\u0625\\u0644\\u0643\\u062a\\u0631\\u0648\\u0646\\u064a.<\\/li><li><strong>\\u0627\\u0644\\u0633\\u0644\\u0637\\u0627\\u062a \\u0627\\u0644\\u062a\\u0646\\u0638\\u064a\\u0645\\u064a\\u0629<\\/strong>: \\u0627\\u0644\\u0648\\u0643\\u0627\\u0644\\u0627\\u062a \\u0627\\u0644\\u062d\\u0643\\u0648\\u0645\\u064a\\u0629 \\u0623\\u0648 \\u0627\\u0644\\u062a\\u0646\\u0638\\u064a\\u0645\\u064a\\u0629 \\u0643\\u0645\\u0627 \\u064a\\u062a\\u0637\\u0644\\u0628 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0644\\u0623\\u063a\\u0631\\u0627\\u0636 \\u0627\\u0644\\u0627\\u0645\\u062a\\u062b\\u0627\\u0644.<\\/li><li><strong>\\u0627\\u0644\\u0641\\u0631\\u0642 \\u0627\\u0644\\u062f\\u0627\\u062e\\u0644\\u064a\\u0629<\\/strong>: \\u0645\\u0646 \\u0623\\u062c\\u0644 \\u0627\\u0644\\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u0627\\u0644\\u0625\\u062f\\u0627\\u0631\\u064a\\u0629 \\u0645\\u062b\\u0644 \\u0625\\u062f\\u0627\\u0631\\u0629 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646\\u060c \\u0625\\u062f\\u0627\\u0631\\u0629 \\u0627\\u0644\\u0645\\u0634\\u0631\\u0641\\u064a\\u0646\\u060c \\u0648\\u0625\\u062f\\u0627\\u0631\\u0629 \\u0627\\u0644\\u0623\\u0631\\u0628\\u0627\\u062d.<\\/li><li><strong>\\u0627\\u0644\\u062a\\u0643\\u0627\\u0645\\u0644\\u0627\\u062a \\u0645\\u0639 \\u0623\\u0637\\u0631\\u0627\\u0641 \\u062b\\u0627\\u0644\\u062b\\u0629<\\/strong>: APIs \\u0644\\u0634\\u062d\\u0646 \\u0627\\u0644\\u0647\\u0648\\u0627\\u062a\\u0641\\u060c \\u0628\\u0637\\u0627\\u0642\\u0627\\u062a \\u0627\\u0644\\u0647\\u062f\\u0627\\u064a\\u0627\\u060c \\u0648\\u0628\\u0648\\u0627\\u0628\\u0627\\u062a \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0639\\u0646\\u062f \\u0627\\u0644\\u062d\\u0627\\u062c\\u0629 \\u0644\\u0625\\u062a\\u0645\\u0627\\u0645 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a.<\\/li><\\/ul><p><strong>\\u0627\\u062d\\u062a\\u0641\\u0627\\u0638 \\u0627\\u0644\\u0628\\u064a\\u0627\\u0646\\u0627\\u062a<\\/strong><br>\\u0646\\u062d\\u062a\\u0641\\u0638 \\u0628\\u0628\\u064a\\u0627\\u0646\\u0627\\u062a\\u0643 \\u0641\\u0642\\u0637 \\u0637\\u0627\\u0644\\u0645\\u0627 \\u0623\\u0646\\u0647\\u0627 \\u0636\\u0631\\u0648\\u0631\\u064a\\u0629 \\u0644\\u062a\\u062d\\u0642\\u064a\\u0642 \\u0627\\u0644\\u0623\\u063a\\u0631\\u0627\\u0636 \\u0627\\u0644\\u0645\\u0648\\u0636\\u062d\\u0629 \\u0641\\u064a \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0633\\u064a\\u0627\\u0633\\u0629 \\u0623\\u0648 \\u0644\\u0644\\u0627\\u0645\\u062a\\u062b\\u0627\\u0644 \\u0644\\u0644\\u0627\\u0644\\u062a\\u0632\\u0627\\u0645\\u0627\\u062a \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629. \\u0642\\u062f \\u064a\\u062a\\u0645 \\u0627\\u0644\\u0627\\u062d\\u062a\\u0641\\u0627\\u0638 \\u0628\\u0633\\u062c\\u0644\\u0627\\u062a \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0648\\u0627\\u0644\\u0633\\u062c\\u0644\\u0627\\u062a \\u0627\\u0644\\u0645\\u0627\\u0644\\u064a\\u0629 \\u0644\\u0623\\u063a\\u0631\\u0627\\u0636 \\u0627\\u0644\\u062a\\u062f\\u0642\\u064a\\u0642 \\u0648\\u0627\\u0644\\u0627\\u0645\\u062a\\u062b\\u0627\\u0644.<\\/p><p><strong>\\u062a\\u062f\\u0627\\u0628\\u064a\\u0631 \\u0627\\u0644\\u0623\\u0645\\u0627\\u0646<\\/strong><br>\\u0646\\u0646\\u0641\\u0630 \\u062a\\u062f\\u0627\\u0628\\u064a\\u0631 \\u0623\\u0645\\u0627\\u0646 \\u0642\\u0648\\u064a\\u0629 \\u0644\\u062d\\u0645\\u0627\\u064a\\u0629 \\u0628\\u064a\\u0627\\u0646\\u0627\\u062a\\u0643\\u060c \\u0628\\u0645\\u0627 \\u0641\\u064a \\u0630\\u0644\\u0643:<\\/p><ul><li><strong>\\u0627\\u0644\\u062a\\u0634\\u0641\\u064a\\u0631<\\/strong>: \\u062a\\u0634\\u0641\\u064a\\u0631 \\u0627\\u0644\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0627\\u0644\\u062d\\u0633\\u0627\\u0633\\u0629 \\u0623\\u062b\\u0646\\u0627\\u0621 \\u0627\\u0644\\u0646\\u0642\\u0644 \\u0648\\u0627\\u0644\\u062a\\u062e\\u0632\\u064a\\u0646.<\\/li><li><strong>\\u0627\\u0644\\u0623\\u0645\\u0627\\u0646 2FA<\\/strong>: \\u062a\\u0645\\u0643\\u064a\\u0646 \\u0627\\u0644\\u0645\\u0635\\u0627\\u062f\\u0642\\u0629 \\u0627\\u0644\\u062b\\u0646\\u0627\\u0626\\u064a\\u0629 \\u0644\\u062d\\u0633\\u0627\\u0628\\u0627\\u062a \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646 \\u0648\\u0627\\u0644\\u0645\\u0634\\u0631\\u0641\\u064a\\u0646.<\\/li><li><strong>\\u0627\\u0644\\u062a\\u062d\\u0643\\u0645 \\u0641\\u064a \\u0627\\u0644\\u0648\\u0635\\u0648\\u0644<\\/strong>: \\u062a\\u0642\\u064a\\u064a\\u062f \\u0627\\u0644\\u0648\\u0635\\u0648\\u0644 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0628\\u064a\\u0627\\u0646\\u0627\\u062a \\u0627\\u0644\\u062d\\u0633\\u0627\\u0633\\u0629 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0623\\u0641\\u0631\\u0627\\u062f \\u0627\\u0644\\u0645\\u0635\\u0631\\u062d \\u0644\\u0647\\u0645 \\u0641\\u0642\\u0637.<\\/li><li><strong>\\u0627\\u0644\\u062a\\u062f\\u0642\\u064a\\u0642\\u0627\\u062a \\u0627\\u0644\\u0645\\u0646\\u062a\\u0638\\u0645\\u0629<\\/strong>: \\u0625\\u062c\\u0631\\u0627\\u0621 \\u0641\\u062d\\u0648\\u0635\\u0627\\u062a \\u062f\\u0648\\u0631\\u064a\\u0629 \\u0644\\u0644\\u062a\\u0623\\u0643\\u062f \\u0645\\u0646 \\u0623\\u0645\\u0627\\u0646 \\u0627\\u0644\\u0645\\u0646\\u0635\\u0629.<\\/li><\\/ul><p><strong>\\u062d\\u0642\\u0648\\u0642 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646<\\/strong><br>\\u0643\\u0640 \\u0645\\u0633\\u062a\\u062e\\u062f\\u0645 \\u0644\\u0640 PayLoad\\u060c \\u0644\\u062f\\u064a\\u0643 \\u0627\\u0644\\u062d\\u0642\\u0648\\u0642 \\u0627\\u0644\\u062a\\u0627\\u0644\\u064a\\u0629:<\\/p><ul><li><strong>\\u0627\\u0644\\u0648\\u0635\\u0648\\u0644 \\u0625\\u0644\\u0649 \\u0628\\u064a\\u0627\\u0646\\u0627\\u062a\\u0643<\\/strong>: \\u0637\\u0644\\u0628 \\u0646\\u0633\\u062e\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0628\\u064a\\u0627\\u0646\\u0627\\u062a \\u0627\\u0644\\u0634\\u062e\\u0635\\u064a\\u0629 \\u0627\\u0644\\u062a\\u064a \\u0646\\u062d\\u062a\\u0641\\u0638 \\u0628\\u0647\\u0627 \\u0639\\u0646\\u0643.<\\/li><li><strong>\\u062a\\u062d\\u062f\\u064a\\u062b \\u0628\\u064a\\u0627\\u0646\\u0627\\u062a\\u0643<\\/strong>: \\u062a\\u0635\\u062d\\u064a\\u062d \\u0623\\u0648 \\u062a\\u062d\\u062f\\u064a\\u062b \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a\\u0643 \\u0627\\u0644\\u0634\\u062e\\u0635\\u064a\\u0629 \\u0639\\u0628\\u0631 \\u0645\\u064a\\u0632\\u0629 \\u062a\\u062d\\u062f\\u064a\\u062b \\u0627\\u0644\\u0645\\u0644\\u0641 \\u0627\\u0644\\u0634\\u062e\\u0635\\u064a.<\\/li><li><strong>\\u062d\\u0630\\u0641 \\u0628\\u064a\\u0627\\u0646\\u0627\\u062a\\u0643<\\/strong>: \\u0637\\u0644\\u0628 \\u062d\\u0630\\u0641 \\u062d\\u0633\\u0627\\u0628\\u0643 \\u0648\\u0627\\u0644\\u0628\\u064a\\u0627\\u0646\\u0627\\u062a \\u0627\\u0644\\u0645\\u0631\\u062a\\u0628\\u0637\\u0629 \\u0628\\u0647\\u060c \\u0645\\u0639 \\u0627\\u0644\\u0627\\u0645\\u062a\\u062b\\u0627\\u0644 \\u0644\\u0644\\u0644\\u0648\\u0627\\u0626\\u062d \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629.<\\/li><li><strong>\\u0642\\u0627\\u0628\\u0644\\u064a\\u0629 \\u0646\\u0642\\u0644 \\u0627\\u0644\\u0628\\u064a\\u0627\\u0646\\u0627\\u062a<\\/strong>: \\u0627\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u0628\\u064a\\u0627\\u0646\\u0627\\u062a\\u0643 \\u0628\\u062a\\u0646\\u0633\\u064a\\u0642 \\u0645\\u0646\\u0638\\u0645 \\u0648\\u0642\\u0627\\u0628\\u0644 \\u0644\\u0644\\u0642\\u0631\\u0627\\u0621\\u0629 \\u0628\\u0648\\u0627\\u0633\\u0637\\u0629 \\u0627\\u0644\\u0622\\u0644\\u0627\\u062a.<\\/li><li><strong>\\u0625\\u0644\\u063a\\u0627\\u0621 \\u0627\\u0644\\u0627\\u0634\\u062a\\u0631\\u0627\\u0643<\\/strong>: \\u0625\\u0644\\u063a\\u0627\\u0621 \\u0627\\u0644\\u0627\\u0634\\u062a\\u0631\\u0627\\u0643 \\u0641\\u064a \\u0627\\u0644\\u0631\\u0633\\u0627\\u0626\\u0644 \\u0627\\u0644\\u062a\\u0631\\u0648\\u064a\\u062c\\u064a\\u0629 \\u0648\\u0627\\u0644\\u0628\\u0631\\u064a\\u062f \\u0627\\u0644\\u0625\\u0644\\u0643\\u062a\\u0631\\u0648\\u0646\\u064a.<\\/li><\\/ul><p><strong>\\u0633\\u064a\\u0627\\u0633\\u0629 \\u0627\\u0644\\u0643\\u0648\\u0643\\u064a\\u0632<\\/strong><br>\\u062a\\u0633\\u062a\\u062e\\u062f\\u0645 \\u0645\\u0646\\u0635\\u062a\\u0646\\u0627 \\u0627\\u0644\\u0643\\u0648\\u0643\\u064a\\u0632 \\u0644\\u062a\\u062d\\u0633\\u064a\\u0646 \\u062a\\u062c\\u0631\\u0628\\u062a\\u0643. \\u0648\\u062a\\u0634\\u0645\\u0644 \\u0647\\u0630\\u0647:<\\/p><ul><li><strong>\\u0627\\u0644\\u0643\\u0648\\u0643\\u064a\\u0632 \\u0627\\u0644\\u0623\\u0633\\u0627\\u0633\\u064a\\u0629<\\/strong>: \\u0627\\u0644\\u0644\\u0627\\u0632\\u0645\\u0629 \\u0644\\u062a\\u0634\\u063a\\u064a\\u0644 \\u0627\\u0644\\u0645\\u0646\\u0635\\u0629.<\\/li><li><strong>\\u0627\\u0644\\u0643\\u0648\\u0643\\u064a\\u0632 \\u0627\\u0644\\u062a\\u062d\\u0644\\u064a\\u0644\\u064a\\u0629<\\/strong>: \\u062a\\u0633\\u0627\\u0639\\u062f\\u0646\\u0627 \\u0641\\u064a \\u0641\\u0647\\u0645 \\u0633\\u0644\\u0648\\u0643 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645 \\u0648\\u062a\\u062d\\u0633\\u064a\\u0646 \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a.<\\/li><li><strong>\\u0627\\u0644\\u0627\\u0645\\u062a\\u062b\\u0627\\u0644 \\u0644\\u0644\\u0640 GDPR<\\/strong>: \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646 \\u0625\\u062f\\u0627\\u0631\\u0629 \\u062a\\u0641\\u0636\\u064a\\u0644\\u0627\\u062a \\u0627\\u0644\\u0643\\u0648\\u0643\\u064a\\u0632 \\u0639\\u0628\\u0631 \\u0635\\u0641\\u062d\\u0629 \\u0625\\u0639\\u062f\\u0627\\u062f\\u0627\\u062a \\u0627\\u0644\\u0643\\u0648\\u0643\\u064a\\u0632.<\\/li><\\/ul><p><strong>\\u0631\\u0648\\u0627\\u0628\\u0637 \\u0627\\u0644\\u0623\\u0637\\u0631\\u0627\\u0641 \\u0627\\u0644\\u062b\\u0627\\u0644\\u062b\\u0629<\\/strong><br>\\u0642\\u062f \\u064a\\u062d\\u062a\\u0648\\u064a PayLoad \\u0639\\u0644\\u0649 \\u0631\\u0648\\u0627\\u0628\\u0637 \\u0644\\u0645\\u0648\\u0627\\u0642\\u0639 \\u0648\\u064a\\u0628 \\u0623\\u0648 \\u062e\\u062f\\u0645\\u0627\\u062a \\u062e\\u0627\\u0631\\u062c\\u064a\\u0629. \\u0646\\u062d\\u0646 \\u063a\\u064a\\u0631 \\u0645\\u0633\\u0624\\u0648\\u0644\\u064a\\u0646 \\u0639\\u0646 \\u0645\\u0645\\u0627\\u0631\\u0633\\u0627\\u062a \\u0627\\u0644\\u062e\\u0635\\u0648\\u0635\\u064a\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0647\\u0645 \\u0623\\u0648 \\u0645\\u062d\\u062a\\u0648\\u064a\\u0627\\u062a\\u0647\\u0645. \\u064a\\u0631\\u062c\\u0649 \\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u0633\\u064a\\u0627\\u0633\\u0627\\u062a \\u0627\\u0644\\u062e\\u0635\\u0648\\u0635\\u064a\\u0629 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0647\\u0645 \\u0642\\u0628\\u0644 \\u0627\\u0644\\u062a\\u0641\\u0627\\u0639\\u0644 \\u0645\\u0639\\u0647\\u0645.<\\/p><p><strong>\\u0646\\u0642\\u0644 \\u0627\\u0644\\u0628\\u064a\\u0627\\u0646\\u0627\\u062a \\u0627\\u0644\\u062f\\u0648\\u0644\\u064a\\u0629<\\/strong><br>\\u0625\\u0630\\u0627 \\u0643\\u0646\\u062a \\u062a\\u0635\\u0644 \\u0625\\u0644\\u0649 PayLoad \\u0645\\u0646 \\u062e\\u0627\\u0631\\u062c \\u0645\\u0646\\u0627\\u0637\\u0642\\u0646\\u0627 \\u0627\\u0644\\u062a\\u0634\\u063a\\u064a\\u0644\\u064a\\u0629\\u060c \\u0642\\u062f \\u064a\\u062a\\u0645 \\u0646\\u0642\\u0644 \\u0628\\u064a\\u0627\\u0646\\u0627\\u062a\\u0643 \\u0648\\u0645\\u0639\\u0627\\u0644\\u062c\\u062a\\u0647\\u0627 \\u0641\\u064a \\u0628\\u0644\\u062f\\u0627\\u0646 \\u0630\\u0627\\u062a \\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u062d\\u0645\\u0627\\u064a\\u0629 \\u0628\\u064a\\u0627\\u0646\\u0627\\u062a \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629. \\u0646\\u062d\\u0646 \\u0646\\u062a\\u0623\\u0643\\u062f \\u0645\\u0646 \\u0623\\u0646 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u062a\\u062d\\u0648\\u064a\\u0644\\u0627\\u062a \\u062a\\u0645\\u062a\\u062b\\u0644 \\u0644\\u0644\\u0648\\u0627\\u0626\\u062d \\u0627\\u0644\\u0645\\u0639\\u0645\\u0648\\u0644 \\u0628\\u0647\\u0627.<\\/p><p><strong>\\u062e\\u0635\\u0648\\u0635\\u064a\\u0629 \\u0627\\u0644\\u0623\\u0637\\u0641\\u0627\\u0644<\\/strong><br>\\u0644\\u0627 \\u064a\\u064f\\u0642\\u0635\\u062f \\u0628\\u0640 PayLoad \\u0623\\u0646 \\u064a\\u0643\\u0648\\u0646 \\u0645\\u062e\\u0635\\u0635\\u064b\\u0627 \\u0644\\u0644\\u0623\\u0641\\u0631\\u0627\\u062f \\u0627\\u0644\\u0630\\u064a\\u0646 \\u062a\\u0642\\u0644 \\u0623\\u0639\\u0645\\u0627\\u0631\\u0647\\u0645 \\u0639\\u0646 18 \\u0639\\u0627\\u0645\\u064b\\u0627. \\u0646\\u062d\\u0646 \\u0644\\u0627 \\u0646\\u062c\\u0645\\u0639 \\u0628\\u064a\\u0627\\u0646\\u0627\\u062a \\u0634\\u062e\\u0635\\u064a\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0623\\u0637\\u0641\\u0627\\u0644 \\u0639\\u0646 \\u0639\\u0644\\u0645. \\u0625\\u0630\\u0627 \\u0643\\u0646\\u062a \\u062a\\u0639\\u062a\\u0642\\u062f \\u0623\\u0646 \\u0637\\u0641\\u0644\\u064b\\u0627 \\u0642\\u062f \\u0642\\u062f\\u0645 \\u0644\\u0646\\u0627 \\u0628\\u064a\\u0627\\u0646\\u0627\\u062a\\u0647\\u060c \\u064a\\u0631\\u062c\\u0649 \\u0627\\u0644\\u0627\\u062a\\u0635\\u0627\\u0644 \\u0628\\u0646\\u0627 \\u0644\\u0625\\u0632\\u0627\\u0644\\u062a\\u0647\\u0627.<\\/p><p><strong>\\u0627\\u0644\\u062a\\u063a\\u064a\\u064a\\u0631\\u0627\\u062a \\u0641\\u064a \\u0633\\u064a\\u0627\\u0633\\u0629 \\u0627\\u0644\\u062e\\u0635\\u0648\\u0635\\u064a\\u0629<\\/strong><br>\\u0642\\u062f \\u0646\\u0642\\u0648\\u0645 \\u0628\\u062a\\u062d\\u062f\\u064a\\u062b \\u0633\\u064a\\u0627\\u0633\\u0629 \\u0627\\u0644\\u062e\\u0635\\u0648\\u0635\\u064a\\u0629 \\u0647\\u0630\\u0647 \\u0645\\u0646 \\u0648\\u0642\\u062a \\u0644\\u0622\\u062e\\u0631. \\u0633\\u064a\\u062a\\u0645 \\u0646\\u0634\\u0631 \\u0627\\u0644\\u062a\\u063a\\u064a\\u064a\\u0631\\u0627\\u062a \\u0639\\u0644\\u0649 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0635\\u0641\\u062d\\u0629 \\u0645\\u0639 \\u062a\\u0627\\u0631\\u064a\\u062e \\u0633\\u0631\\u064a\\u0627\\u0646 \\u0645\\u0639\\u062f\\u0651\\u0644. \\u064a\\u0631\\u062c\\u0649 \\u0645\\u0631\\u0627\\u062c\\u0639\\u062a\\u0647\\u0627 \\u0628\\u0627\\u0646\\u062a\\u0638\\u0627\\u0645 \\u0644\\u0644\\u0628\\u0642\\u0627\\u0621 \\u0639\\u0644\\u0649 \\u0627\\u0637\\u0644\\u0627\\u0639 \\u062d\\u0648\\u0644 \\u0643\\u064a\\u0641\\u064a\\u0629 \\u062d\\u0645\\u0627\\u064a\\u0629 \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a\\u0643.<\\/p>"}}}','status' => '1','editable' => '0','created_at' => '2023-07-31 12:02:44','updated_at' => '2024-12-11 13:23:19'),
  array('id' => '2','type' => 'UNKNOWN','title' => '{"language":{"en":{"title":"Refund Policy"},"fr":{"title":"Politique de remboursement"},"es":{"title":"Pol\\u00edtica de reembolso"},"ar":{"title":"\\u0633\\u064a\\u0627\\u0633\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0631\\u062c\\u0627\\u0639"}}}','slug' => 'refund-policy','url' => 'refund-policy','content' => '{"language":{"en":{"content":"<p><strong>Introduction<\\/strong> At PayLoad, we strive to provide the best experience for our users. This Refund Policy outlines the circumstances under which refunds may be issued for services such as mobile top-ups, gift card purchases, and wallet deposits. By using PayLoad, you agree to the terms of this Refund Policy.<br><strong>Refund Eligibility<\\/strong> Refunds are only applicable under the following conditions:<br>&nbsp;<\\/p><ol style=\\"list-style-type:decimal;\\"><li><strong>Mobile Top-Ups:<\\/strong><ul style=\\"list-style-type:none;\\"><li>A refund will be issued if the top-up fails to process, and the amount has been deducted from your wallet or payment method.<\\/li><li>If the top-up is credited to an incorrect number due to user error, refunds are not eligible.<\\/li><\\/ul><\\/li><li><strong>Gift Card Purchases:<\\/strong><ul style=\\"list-style-type:none;\\"><li>Refunds will be considered only if the purchased gift card has not been redeemed and is proven to be defective or invalid.<\\/li><li>If a gift card has been successfully delivered and redeemed, no refunds will be provided.<\\/li><\\/ul><\\/li><li><strong>Wallet Deposits:<\\/strong><ul style=\\"list-style-type:none;\\"><li>Refunds for wallet deposits are only applicable if the amount has been deducted but not credited to your wallet due to technical issues.<\\/li><li>Refunds will not be provided for voluntary wallet deposits once successfully processed.<\\/li><\\/ul><\\/li><li><strong>System Errors or Technical Failures:<\\/strong><ul style=\\"list-style-type:none;\\"><li>In the event of double payments, incorrect charges, or system errors, PayLoad will investigate and issue refunds accordingly.<\\/li><\\/ul><\\/li><\\/ol><p><strong>Refund Process<\\/strong> To request a refund, follow these steps:<br>&nbsp;<\\/p><ol style=\\"list-style-type:decimal;\\"><li>Contact our customer support team via [Insert Support Email] or [Insert Support Phone Number].<\\/li><li>Provide the transaction details, including the date, amount, and a description of the issue.<\\/li><li>Our team will review your request and respond within 5-7 business days.<\\/li><li>Approved refunds will be processed using the original payment method within 7-14 business days.<\\/li><\\/ol><p><strong>Important Notes:<\\/strong><br>&nbsp;<\\/p><ul style=\\"list-style-type:none;\\"><li>Refund requests must be made within 15 days of the transaction date.<\\/li><li>PayLoad reserves the right to refuse refunds if fraudulent activity or misuse is suspected.<\\/li><li>Any fees or charges associated with transactions are non-refundable unless due to system errors.<\\/li><\\/ul><p><strong>Non-Refundable Items<\\/strong> The following are not eligible for refunds:<br>&nbsp;<\\/p><ol style=\\"list-style-type:decimal;\\"><li>Successfully processed mobile top-ups.<\\/li><li>Redeemed or delivered gift cards.<\\/li><li>Wallet deposits completed without technical issues.<\\/li><li>Fees and charges for services rendered.<\\/li><\\/ol><p><strong>Dispute Resolution<\\/strong> If you are not satisfied with the outcome of your refund request, you may escalate the matter to our dispute resolution team at [Insert Email]. We are committed to resolving issues fairly and transparently.<br><strong>Changes to This Refund Policy<\\/strong> PayLoad may update this Refund Policy from time to time. Changes will be posted on this page with a revised effective date. We encourage you to review this policy periodically to stay informed about our refund practices.<\\/p>"},"fr":{"content":"<p><strong>Introduction<\\/strong><br>Chez PayLoad, nous nous effor\\u00e7ons de fournir la meilleure exp\\u00e9rience possible \\u00e0 nos utilisateurs. Cette politique de remboursement d\\u00e9crit les circonstances dans lesquelles des remboursements peuvent \\u00eatre effectu\\u00e9s pour des services tels que les recharges mobiles, les achats de cartes-cadeaux et les d\\u00e9p\\u00f4ts dans le portefeuille. En utilisant PayLoad, vous acceptez les termes de cette politique de remboursement.<\\/p><p><strong>\\u00c9ligibilit\\u00e9 au remboursement<\\/strong><br>Les remboursements ne sont applicables que dans les conditions suivantes :<br>Recharges mobiles :<br>Un remboursement sera \\u00e9mis si la recharge \\u00e9choue \\u00e0 traiter et que le montant a \\u00e9t\\u00e9 d\\u00e9duit de votre portefeuille ou m\\u00e9thode de paiement.<br>Si la recharge est cr\\u00e9dit\\u00e9e sur un num\\u00e9ro incorrect en raison d\'une erreur de l\'utilisateur, les remboursements ne sont pas \\u00e9ligibles.<br>Achats de cartes-cadeaux :<br>Les remboursements seront envisag\\u00e9s uniquement si la carte-cadeau achet\\u00e9e n\'a pas \\u00e9t\\u00e9 utilis\\u00e9e et s\'il est prouv\\u00e9 qu\'elle est d\\u00e9fectueuse ou invalide.<br>Si une carte-cadeau a \\u00e9t\\u00e9 livr\\u00e9e avec succ\\u00e8s et utilis\\u00e9e, aucun remboursement ne sera fourni.<br>D\\u00e9p\\u00f4ts dans le portefeuille :<br>Les remboursements pour les d\\u00e9p\\u00f4ts dans le portefeuille ne sont applicables que si le montant a \\u00e9t\\u00e9 d\\u00e9duit mais n\'a pas \\u00e9t\\u00e9 cr\\u00e9dit\\u00e9 sur votre portefeuille en raison de probl\\u00e8mes techniques.<br>Les remboursements ne seront pas fournis pour les d\\u00e9p\\u00f4ts volontaires dans le portefeuille une fois trait\\u00e9s avec succ\\u00e8s.<br>Erreurs syst\\u00e8me ou pannes techniques :<br>En cas de paiements doubles, de frais incorrects ou d\'erreurs syst\\u00e8me, PayLoad enqu\\u00eatera et effectuera les remboursements en cons\\u00e9quence.<\\/p><p><strong>Processus de remboursement<\\/strong><br>Pour demander un remboursement, suivez ces \\u00e9tapes :<\\/p><ol><li>Contactez notre \\u00e9quipe de support client via [Ins\\u00e9rer l\'email de support] ou [Ins\\u00e9rer le num\\u00e9ro de t\\u00e9l\\u00e9phone de support].<\\/li><li>Fournissez les d\\u00e9tails de la transaction, y compris la date, le montant et une description du probl\\u00e8me.<\\/li><li>Notre \\u00e9quipe examinera votre demande et r\\u00e9pondra dans un d\\u00e9lai de 5 \\u00e0 7 jours ouvrables.<\\/li><li>Les remboursements approuv\\u00e9s seront trait\\u00e9s en utilisant le mode de paiement original dans un d\\u00e9lai de 7 \\u00e0 14 jours ouvrables.<\\/li><\\/ol><p><strong>Notes importantes :<\\/strong><\\/p><ul><li>Les demandes de remboursement doivent \\u00eatre faites dans les 15 jours suivant la date de la transaction.<\\/li><li>PayLoad se r\\u00e9serve le droit de refuser des remboursements en cas d\'activit\\u00e9 frauduleuse ou d\'abus suspect\\u00e9.<\\/li><li>Les frais ou charges associ\\u00e9s aux transactions ne sont pas remboursables, sauf en cas d\'erreurs syst\\u00e8me.<\\/li><\\/ul><p><strong>Articles non remboursables<\\/strong><br>Les \\u00e9l\\u00e9ments suivants ne sont pas \\u00e9ligibles au remboursement :<\\/p><ul><li>Recharges mobiles trait\\u00e9es avec succ\\u00e8s.<\\/li><li>Cartes-cadeaux utilis\\u00e9es ou livr\\u00e9es.<\\/li><li>D\\u00e9p\\u00f4ts dans le portefeuille effectu\\u00e9s sans probl\\u00e8mes techniques.<\\/li><li>Frais et charges pour services rendus.<\\/li><\\/ul><p><strong>R\\u00e9solution des litiges<\\/strong><br>Si vous n\'\\u00eates pas satisfait du r\\u00e9sultat de votre demande de remboursement, vous pouvez escalader la question \\u00e0 notre \\u00e9quipe de r\\u00e9solution des litiges \\u00e0 [Ins\\u00e9rer Email]. Nous nous engageons \\u00e0 r\\u00e9soudre les probl\\u00e8mes de mani\\u00e8re \\u00e9quitable et transparente.<\\/p><p><strong>Modifications de cette politique de remboursement<\\/strong><br>PayLoad peut mettre \\u00e0 jour cette politique de remboursement de temps en temps. Les modifications seront publi\\u00e9es sur cette page avec une date d\'entr\\u00e9e en vigueur r\\u00e9vis\\u00e9e. Nous vous encourageons \\u00e0 consulter cette politique p\\u00e9riodiquement pour rester inform\\u00e9 sur nos pratiques de remboursement.<\\/p>"},"es":{"content":"<p><strong>Introducci\\u00f3n<\\/strong><br>En PayLoad, nos esforzamos por brindar la mejor experiencia posible a nuestros usuarios. Esta Pol\\u00edtica de Reembolso describe las circunstancias en las que se pueden emitir reembolsos por servicios como recargas m\\u00f3viles, compras de tarjetas de regalo y dep\\u00f3sitos en monedero. Al usar PayLoad, usted acepta los t\\u00e9rminos de esta Pol\\u00edtica de Reembolso.<\\/p><p><strong>Elegibilidad para reembolsos<\\/strong><br>Los reembolsos solo son aplicables bajo las siguientes condiciones:<br>Recargas m\\u00f3viles:<br>Se emitir\\u00e1 un reembolso si la recarga no se procesa y se ha deducido el monto de su monedero o m\\u00e9todo de pago.<br>Si la recarga se acredita a un n\\u00famero incorrecto debido a un error del usuario, no ser\\u00e1n elegibles para reembolso.<br>Compras de tarjetas de regalo:<br>Se considerar\\u00e1n reembolsos solo si la tarjeta de regalo comprada no ha sido canjeada y se demuestra que est\\u00e1 defectuosa o es inv\\u00e1lida.<br>Si una tarjeta de regalo ha sido entregada y canjeada con \\u00e9xito, no se proporcionar\\u00e1n reembolsos.<br>Dep\\u00f3sitos en el monedero:<br>Los reembolsos por dep\\u00f3sitos en el monedero solo son aplicables si el monto ha sido deducido pero no acreditado en su monedero debido a problemas t\\u00e9cnicos.<br>No se proporcionar\\u00e1n reembolsos por dep\\u00f3sitos voluntarios en el monedero una vez procesados con \\u00e9xito.<br>Errores del sistema o fallos t\\u00e9cnicos:<br>En caso de pagos dobles, cargos incorrectos o errores del sistema, PayLoad investigar\\u00e1 y emitir\\u00e1 reembolsos seg\\u00fan corresponda.<\\/p><p><strong>Proceso de reembolso<\\/strong><br>Para solicitar un reembolso, siga estos pasos:<\\/p><ol><li>Contacte con nuestro equipo de atenci\\u00f3n al cliente a trav\\u00e9s de [Insertar correo de soporte] o [Insertar n\\u00famero de tel\\u00e9fono de soporte].<\\/li><li>Proporcione los detalles de la transacci\\u00f3n, incluyendo la fecha, el monto y una descripci\\u00f3n del problema.<\\/li><li>Nuestro equipo revisar\\u00e1 su solicitud y responder\\u00e1 dentro de 5 a 7 d\\u00edas h\\u00e1biles.<\\/li><li>Los reembolsos aprobados se procesar\\u00e1n utilizando el m\\u00e9todo de pago original dentro de 7 a 14 d\\u00edas h\\u00e1biles.<\\/li><\\/ol><p><strong>Notas importantes:<\\/strong><\\/p><ul><li>Las solicitudes de reembolso deben realizarse dentro de los 15 d\\u00edas posteriores a la fecha de la transacci\\u00f3n.<\\/li><li>PayLoad se reserva el derecho de rechazar reembolsos si se sospecha de actividad fraudulenta o abuso.<\\/li><li>Las tarifas o cargos asociados con las transacciones no son reembolsables, a menos que sea debido a errores del sistema.<\\/li><\\/ul><p><strong>Art\\u00edculos no reembolsables<\\/strong><br>No son elegibles para reembolso los siguientes elementos:<\\/p><ul><li>Recargas m\\u00f3viles procesadas con \\u00e9xito.<\\/li><li>Tarjetas de regalo canjeadas o entregadas.<\\/li><li>Dep\\u00f3sitos en el monedero completados sin problemas t\\u00e9cnicos.<\\/li><li>Tarifas y cargos por servicios prestados.<\\/li><\\/ul><p><strong>Resoluci\\u00f3n de disputas<\\/strong><br>Si no est\\u00e1 satisfecho con el resultado de su solicitud de reembolso, puede escalar el asunto a nuestro equipo de resoluci\\u00f3n de disputas en [Insertar correo]. Nos comprometemos a resolver los problemas de manera justa y transparente.<\\/p><p><strong>Cambios en esta Pol\\u00edtica de Reembolso<\\/strong><br>PayLoad puede actualizar esta Pol\\u00edtica de Reembolso de vez en cuando. Los cambios se publicar\\u00e1n en esta p\\u00e1gina con una fecha de vigencia revisada. Le recomendamos revisar esta pol\\u00edtica peri\\u00f3dicamente para estar informado sobre nuestras pr\\u00e1cticas de reembolso.<\\/p>"},"ar":{"content":"<p><strong>\\u0645\\u0642\\u062f\\u0645\\u0629<\\/strong><br>\\u0641\\u064a PayLoad\\u060c \\u0646\\u0633\\u0639\\u0649 \\u062c\\u0627\\u0647\\u062f\\u064a\\u0646 \\u0644\\u062a\\u0648\\u0641\\u064a\\u0631 \\u0623\\u0641\\u0636\\u0644 \\u062a\\u062c\\u0631\\u0628\\u0629 \\u0645\\u0645\\u0643\\u0646\\u0629 \\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646\\u0627. \\u062a\\u062d\\u062f\\u062f \\u0633\\u064a\\u0627\\u0633\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0631\\u062c\\u0627\\u0639 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0638\\u0631\\u0648\\u0641 \\u0627\\u0644\\u062a\\u064a \\u0642\\u062f \\u064a\\u062a\\u0645 \\u0641\\u064a\\u0647\\u0627 \\u0625\\u0635\\u062f\\u0627\\u0631 \\u0627\\u0633\\u062a\\u0631\\u062c\\u0627\\u0639 \\u0644\\u0644\\u0645\\u062f\\u0641\\u0648\\u0639\\u0627\\u062a \\u0645\\u0642\\u0627\\u0628\\u0644 \\u062e\\u062f\\u0645\\u0627\\u062a \\u0645\\u062b\\u0644 \\u062a\\u0639\\u0628\\u0626\\u0629 \\u0627\\u0644\\u0631\\u0635\\u064a\\u062f\\u060c \\u0634\\u0631\\u0627\\u0621 \\u0628\\u0637\\u0627\\u0642\\u0627\\u062a \\u0627\\u0644\\u0647\\u062f\\u0627\\u064a\\u0627\\u060c \\u0648\\u0625\\u064a\\u062f\\u0627\\u0639 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0645\\u062d\\u0641\\u0638\\u0629. \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645\\u0643 \\u0644\\u0640 PayLoad\\u060c \\u0641\\u0625\\u0646\\u0643 \\u062a\\u0648\\u0627\\u0641\\u0642 \\u0639\\u0644\\u0649 \\u0634\\u0631\\u0648\\u0637 \\u0633\\u064a\\u0627\\u0633\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0631\\u062c\\u0627\\u0639 \\u0647\\u0630\\u0647.<\\/p><p><strong>\\u0623\\u0647\\u0644\\u064a\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0631\\u062c\\u0627\\u0639<\\/strong><br>\\u064a\\u062a\\u0645 \\u062a\\u0637\\u0628\\u064a\\u0642 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0631\\u062c\\u0627\\u0639 \\u0641\\u0642\\u0637 \\u0641\\u064a \\u0627\\u0644\\u062d\\u0627\\u0644\\u0627\\u062a \\u0627\\u0644\\u062a\\u0627\\u0644\\u064a\\u0629:<br>\\u062a\\u0639\\u0628\\u0626\\u0629 \\u0627\\u0644\\u0631\\u0635\\u064a\\u062f:<br>\\u0633\\u064a\\u062a\\u0645 \\u0625\\u0635\\u062f\\u0627\\u0631 \\u0627\\u0633\\u062a\\u0631\\u062c\\u0627\\u0639 \\u0625\\u0630\\u0627 \\u0641\\u0634\\u0644\\u062a \\u0639\\u0645\\u0644\\u064a\\u0629 \\u062a\\u0639\\u0628\\u0626\\u0629 \\u0627\\u0644\\u0631\\u0635\\u064a\\u062f \\u0648\\u062a\\u0645 \\u062e\\u0635\\u0645 \\u0627\\u0644\\u0645\\u0628\\u0644\\u063a \\u0645\\u0646 \\u0645\\u062d\\u0641\\u0638\\u062a\\u0643 \\u0623\\u0648 \\u0648\\u0633\\u064a\\u0644\\u0629 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0643.<br>\\u0625\\u0630\\u0627 \\u062a\\u0645 \\u062a\\u0639\\u0628\\u0626\\u0629 \\u0627\\u0644\\u0631\\u0635\\u064a\\u062f \\u0639\\u0644\\u0649 \\u0631\\u0642\\u0645 \\u062e\\u0627\\u0637\\u0626 \\u0628\\u0633\\u0628\\u0628 \\u062e\\u0637\\u0623 \\u0645\\u0646 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u060c \\u0641\\u0644\\u0646 \\u064a\\u0643\\u0648\\u0646 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0631\\u062c\\u0627\\u0639 \\u0645\\u0624\\u0647\\u0644\\u0627\\u064b.<br>\\u0634\\u0631\\u0627\\u0621 \\u0628\\u0637\\u0627\\u0642\\u0627\\u062a \\u0627\\u0644\\u0647\\u062f\\u0627\\u064a\\u0627:<br>\\u0633\\u064a\\u062a\\u0645 \\u0627\\u0644\\u0646\\u0638\\u0631 \\u0641\\u064a \\u0627\\u0644\\u0627\\u0633\\u062a\\u0631\\u062c\\u0627\\u0639 \\u0641\\u0642\\u0637 \\u0625\\u0630\\u0627 \\u0644\\u0645 \\u064a\\u062a\\u0645 \\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0628\\u0637\\u0627\\u0642\\u0629 \\u0627\\u0644\\u0647\\u062f\\u0627\\u064a\\u0627 \\u0627\\u0644\\u0645\\u0634\\u062a\\u0631\\u0627\\u0629 \\u0648\\u062a\\u0628\\u064a\\u0646 \\u0623\\u0646\\u0647\\u0627 \\u0645\\u0639\\u0637\\u0644\\u0629 \\u0623\\u0648 \\u063a\\u064a\\u0631 \\u0635\\u0627\\u0644\\u062d\\u0629.<br>\\u0625\\u0630\\u0627 \\u062a\\u0645 \\u062a\\u0633\\u0644\\u064a\\u0645 \\u0628\\u0637\\u0627\\u0642\\u0629 \\u0627\\u0644\\u0647\\u062f\\u0627\\u064a\\u0627 \\u0648\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645\\u0647\\u0627 \\u0628\\u0646\\u062c\\u0627\\u062d\\u060c \\u0641\\u0644\\u0646 \\u064a\\u062a\\u0645 \\u062a\\u0642\\u062f\\u064a\\u0645 \\u0627\\u0633\\u062a\\u0631\\u062c\\u0627\\u0639.<br>\\u0625\\u064a\\u062f\\u0627\\u0639 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0645\\u062d\\u0641\\u0638\\u0629:<br>\\u0627\\u0644\\u0627\\u0633\\u062a\\u0631\\u062c\\u0627\\u0639 \\u0645\\u062a\\u0627\\u062d \\u0641\\u0642\\u0637 \\u0625\\u0630\\u0627 \\u062a\\u0645 \\u062e\\u0635\\u0645 \\u0627\\u0644\\u0645\\u0628\\u0644\\u063a \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0645 \\u064a\\u062a\\u0645 \\u0625\\u064a\\u062f\\u0627\\u0639\\u0647 \\u0641\\u064a \\u0645\\u062d\\u0641\\u0638\\u062a\\u0643 \\u0628\\u0633\\u0628\\u0628 \\u0645\\u0634\\u0643\\u0644\\u0627\\u062a \\u062a\\u0642\\u0646\\u064a\\u0629.<br>\\u0644\\u0646 \\u064a\\u062a\\u0645 \\u062a\\u0642\\u062f\\u064a\\u0645 \\u0627\\u0633\\u062a\\u0631\\u062c\\u0627\\u0639 \\u0644\\u0644\\u0648\\u062f\\u0627\\u0626\\u0639 \\u0627\\u0644\\u0637\\u0648\\u0639\\u064a\\u0629 \\u0641\\u064a \\u0627\\u0644\\u0645\\u062d\\u0641\\u0638\\u0629 \\u0628\\u0645\\u062c\\u0631\\u062f \\u0645\\u0639\\u0627\\u0644\\u062c\\u062a\\u0647\\u0627 \\u0628\\u0646\\u062c\\u0627\\u062d.<br>\\u0623\\u062e\\u0637\\u0627\\u0621 \\u0627\\u0644\\u0646\\u0638\\u0627\\u0645 \\u0623\\u0648 \\u0627\\u0644\\u0641\\u0634\\u0644 \\u0627\\u0644\\u062a\\u0642\\u0646\\u064a:<br>\\u0641\\u064a \\u062d\\u0627\\u0644\\u0629 \\u0648\\u062c\\u0648\\u062f \\u0645\\u062f\\u0641\\u0648\\u0639\\u0627\\u062a \\u0645\\u0632\\u062f\\u0648\\u062c\\u0629\\u060c \\u0623\\u0648 \\u0631\\u0633\\u0648\\u0645 \\u063a\\u064a\\u0631 \\u0635\\u062d\\u064a\\u062d\\u0629\\u060c \\u0623\\u0648 \\u0623\\u062e\\u0637\\u0627\\u0621 \\u0641\\u064a \\u0627\\u0644\\u0646\\u0638\\u0627\\u0645\\u060c \\u0633\\u062a\\u0642\\u0648\\u0645 PayLoad \\u0628\\u0627\\u0644\\u062a\\u062d\\u0642\\u064a\\u0642 \\u0648\\u0625\\u062c\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0631\\u062c\\u0627\\u0639 \\u0628\\u0646\\u0627\\u0621\\u064b \\u0639\\u0644\\u0649 \\u0630\\u0644\\u0643.<\\/p><p><strong>\\u0639\\u0645\\u0644\\u064a\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0631\\u062c\\u0627\\u0639<\\/strong><br>\\u0644\\u0637\\u0644\\u0628 \\u0627\\u0633\\u062a\\u0631\\u062c\\u0627\\u0639\\u060c \\u0627\\u062a\\u0628\\u0639 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u062e\\u0637\\u0648\\u0627\\u062a:<\\/p><ol><li>\\u0627\\u062a\\u0635\\u0644 \\u0628\\u0641\\u0631\\u064a\\u0642 \\u062f\\u0639\\u0645 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u0621 \\u0644\\u062f\\u064a\\u0646\\u0627 \\u0639\\u0628\\u0631 [\\u0625\\u062f\\u0631\\u0627\\u062c \\u0628\\u0631\\u064a\\u062f \\u0627\\u0644\\u062f\\u0639\\u0645] \\u0623\\u0648 [\\u0625\\u062f\\u0631\\u0627\\u062c \\u0631\\u0642\\u0645 \\u062f\\u0639\\u0645 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u0621].<\\/li><li>\\u0642\\u062f\\u0645 \\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0629\\u060c \\u0628\\u0645\\u0627 \\u0641\\u064a \\u0630\\u0644\\u0643 \\u0627\\u0644\\u062a\\u0627\\u0631\\u064a\\u062e \\u0648\\u0627\\u0644\\u0645\\u0628\\u0644\\u063a \\u0648\\u0648\\u0635\\u0641 \\u0627\\u0644\\u0645\\u0634\\u0643\\u0644\\u0629.<\\/li><li>\\u0633\\u064a\\u0642\\u0648\\u0645 \\u0641\\u0631\\u064a\\u0642\\u0646\\u0627 \\u0628\\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u0637\\u0644\\u0628\\u0643 \\u0648\\u0627\\u0644\\u0631\\u062f \\u0639\\u0644\\u064a\\u0643 \\u062e\\u0644\\u0627\\u0644 5 \\u0625\\u0644\\u0649 7 \\u0623\\u064a\\u0627\\u0645 \\u0639\\u0645\\u0644.<\\/li><li>\\u0633\\u064a\\u062a\\u0645 \\u0645\\u0639\\u0627\\u0644\\u062c\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0631\\u062c\\u0627\\u0639\\u0627\\u062a \\u0627\\u0644\\u0645\\u0639\\u062a\\u0645\\u062f\\u0629 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0627\\u0644\\u0623\\u0635\\u0644\\u064a\\u0629 \\u062e\\u0644\\u0627\\u0644 7 \\u0625\\u0644\\u0649 14 \\u064a\\u0648\\u0645 \\u0639\\u0645\\u0644.<\\/li><\\/ol><p><strong>\\u0645\\u0644\\u0627\\u062d\\u0638\\u0627\\u062a \\u0647\\u0627\\u0645\\u0629:<\\/strong><\\/p><ul><li>\\u064a\\u062c\\u0628 \\u062a\\u0642\\u062f\\u064a\\u0645 \\u0637\\u0644\\u0628\\u0627\\u062a \\u0627\\u0644\\u0627\\u0633\\u062a\\u0631\\u062c\\u0627\\u0639 \\u062e\\u0644\\u0627\\u0644 15 \\u064a\\u0648\\u0645\\u064b\\u0627 \\u0645\\u0646 \\u062a\\u0627\\u0631\\u064a\\u062e \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0629.<\\/li><li>\\u062a\\u062d\\u062a\\u0641\\u0638 PayLoad \\u0628\\u062d\\u0642\\u0647\\u0627 \\u0641\\u064a \\u0631\\u0641\\u0636 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0631\\u062c\\u0627\\u0639 \\u0625\\u0630\\u0627 \\u062a\\u0645 \\u0627\\u0644\\u0627\\u0634\\u062a\\u0628\\u0627\\u0647 \\u0641\\u064a \\u0646\\u0634\\u0627\\u0637 \\u0627\\u062d\\u062a\\u064a\\u0627\\u0644\\u064a \\u0623\\u0648 \\u0633\\u0648\\u0621 \\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645.<\\/li><li>\\u0627\\u0644\\u0631\\u0633\\u0648\\u0645 \\u0623\\u0648 \\u0627\\u0644\\u062a\\u0643\\u0627\\u0644\\u064a\\u0641 \\u0627\\u0644\\u0645\\u0631\\u062a\\u0628\\u0637\\u0629 \\u0628\\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u063a\\u064a\\u0631 \\u0642\\u0627\\u0628\\u0644\\u0629 \\u0644\\u0644\\u0627\\u0633\\u062a\\u0631\\u062c\\u0627\\u0639 \\u0625\\u0644\\u0627 \\u0641\\u064a \\u062d\\u0627\\u0644\\u0629 \\u0648\\u062c\\u0648\\u062f \\u0623\\u062e\\u0637\\u0627\\u0621 \\u0641\\u064a \\u0627\\u0644\\u0646\\u0638\\u0627\\u0645.<\\/li><\\/ul><p><strong>\\u0627\\u0644\\u0639\\u0646\\u0627\\u0635\\u0631 \\u063a\\u064a\\u0631 \\u0627\\u0644\\u0642\\u0627\\u0628\\u0644\\u0629 \\u0644\\u0644\\u0627\\u0633\\u062a\\u0631\\u062c\\u0627\\u0639<\\/strong><br>\\u0627\\u0644\\u0639\\u0646\\u0627\\u0635\\u0631 \\u0627\\u0644\\u062a\\u0627\\u0644\\u064a\\u0629 \\u063a\\u064a\\u0631 \\u0645\\u0624\\u0647\\u0644\\u0629 \\u0644\\u0644\\u0627\\u0633\\u062a\\u0631\\u062c\\u0627\\u0639:<\\/p><ul><li>\\u062a\\u0639\\u0628\\u0626\\u0629 \\u0627\\u0644\\u0631\\u0635\\u064a\\u062f \\u0627\\u0644\\u062a\\u064a \\u062a\\u0645\\u062a \\u0628\\u0646\\u062c\\u0627\\u062d.<\\/li><li>\\u0628\\u0637\\u0627\\u0642\\u0627\\u062a \\u0627\\u0644\\u0647\\u062f\\u0627\\u064a\\u0627 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0645 \\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645\\u0647\\u0627 \\u0623\\u0648 \\u062a\\u0633\\u0644\\u064a\\u0645\\u0647\\u0627.<\\/li><li>\\u0627\\u0644\\u0625\\u064a\\u062f\\u0627\\u0639\\u0627\\u062a \\u0641\\u064a \\u0627\\u0644\\u0645\\u062d\\u0641\\u0638\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0645\\u062a \\u0628\\u062f\\u0648\\u0646 \\u0645\\u0634\\u0643\\u0644\\u0627\\u062a \\u062a\\u0642\\u0646\\u064a\\u0629.<\\/li><li>\\u0627\\u0644\\u0631\\u0633\\u0648\\u0645 \\u0648\\u0627\\u0644\\u062a\\u0643\\u0627\\u0644\\u064a\\u0641 \\u0645\\u0642\\u0627\\u0628\\u0644 \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u0645\\u0642\\u062f\\u0645\\u0629.<\\/li><\\/ul><p><strong>\\u062d\\u0644 \\u0627\\u0644\\u0646\\u0632\\u0627\\u0639\\u0627\\u062a<\\/strong><br>\\u0625\\u0630\\u0627 \\u0644\\u0645 \\u062a\\u0643\\u0646 \\u0631\\u0627\\u0636\\u064a\\u064b\\u0627 \\u0639\\u0646 \\u0646\\u062a\\u064a\\u062c\\u0629 \\u0637\\u0644\\u0628 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0631\\u062c\\u0627\\u0639\\u060c \\u064a\\u0645\\u0643\\u0646\\u0643 \\u062a\\u0635\\u0639\\u064a\\u062f \\u0627\\u0644\\u0645\\u0633\\u0623\\u0644\\u0629 \\u0625\\u0644\\u0649 \\u0641\\u0631\\u064a\\u0642 \\u062d\\u0644 \\u0627\\u0644\\u0646\\u0632\\u0627\\u0639\\u0627\\u062a \\u0644\\u062f\\u064a\\u0646\\u0627 \\u0639\\u0628\\u0631 [\\u0625\\u062f\\u0631\\u0627\\u062c \\u0627\\u0644\\u0628\\u0631\\u064a\\u062f]. \\u0646\\u062d\\u0646 \\u0645\\u0644\\u062a\\u0632\\u0645\\u0648\\u0646 \\u0628\\u062d\\u0644 \\u0627\\u0644\\u0645\\u0634\\u0643\\u0644\\u0627\\u062a \\u0628\\u0634\\u0643\\u0644 \\u0639\\u0627\\u062f\\u0644 \\u0648\\u0634\\u0641\\u0627\\u0641.<\\/p><p><strong>\\u0627\\u0644\\u062a\\u063a\\u064a\\u064a\\u0631\\u0627\\u062a \\u0641\\u064a \\u0633\\u064a\\u0627\\u0633\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0631\\u062c\\u0627\\u0639<\\/strong><br>\\u0642\\u062f \\u062a\\u0642\\u0648\\u0645 PayLoad \\u0628\\u062a\\u062d\\u062f\\u064a\\u062b \\u0633\\u064a\\u0627\\u0633\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0631\\u062c\\u0627\\u0639 \\u0647\\u0630\\u0647 \\u0645\\u0646 \\u0648\\u0642\\u062a \\u0644\\u0622\\u062e\\u0631. \\u0633\\u064a\\u062a\\u0645 \\u0646\\u0634\\u0631 \\u0627\\u0644\\u062a\\u063a\\u064a\\u064a\\u0631\\u0627\\u062a \\u0639\\u0644\\u0649 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0635\\u0641\\u062d\\u0629 \\u0645\\u0639 \\u062a\\u0627\\u0631\\u064a\\u062e \\u0633\\u0631\\u064a\\u0627\\u0646 \\u0645\\u0639\\u062f\\u0651\\u0644. \\u0646\\u0648\\u0635\\u064a\\u0643 \\u0628\\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0633\\u064a\\u0627\\u0633\\u0629 \\u0628\\u0634\\u0643\\u0644 \\u062f\\u0648\\u0631\\u064a \\u0644\\u0644\\u0628\\u0642\\u0627\\u0621 \\u0639\\u0644\\u0649 \\u0627\\u0637\\u0644\\u0627\\u0639 \\u0639\\u0644\\u0649 \\u0645\\u0645\\u0627\\u0631\\u0633\\u0627\\u062a \\u0627\\u0644\\u0627\\u0633\\u062a\\u0631\\u062c\\u0627\\u0639 \\u0644\\u062f\\u064a\\u0646\\u0627.<\\/p>"}}}','status' => '1','editable' => '1','created_at' => '2023-08-10 20:19:01','updated_at' => '2024-12-11 13:47:01')
        );

        UsefulLink::insert($useful_links);
    }
}
