<?php

namespace Database\Seeders\Admin;

use App\Constants\PaymentGatewayConst;
use App\Models\Admin\PaymentGateway;
use App\Models\Admin\PaymentGatewayCurrency;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class PaymentGatewaySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Update Seeder Files
        $payment_gateways = array(
            array('id' => '1', 'slug' => 'add-money', 'code' => '105', 'type' => 'AUTOMATIC', 'name' => 'Paypal', 'title' => 'Paypal Gateway', 'alias' => 'paypal', 'image' => '0bb65be8-a0cf-4d63-b9d7-5f5d7d76ce35.webp', 'credentials' => '[{"label":"Client ID","placeholder":"Enter Client ID","name":"client-id","value":"ASuAkb_xKKu00hA1Pk32UMJvBqE7-GizN2xxBH2nlQgkvGSpgl_h_fmvYiRw__lSwYnw6Bu0G9qtjEY6"},{"label":"Secret ID","placeholder":"Enter Secret ID","name":"secret-id","value":"EHtZKs6f0h6wDSKykJA4lJMU6GVGTc5GARto_EKQS1R5iGA2Z8n_F8sBQPTmcMWHav1GWNl8iJj169u0"}]', 'supported_currencies' => '["USD","GBP","PHP","NZD","MYR","EUR","CNY","CAD","AUD"]', 'crypto' => '0', 'desc' => NULL, 'input_fields' => NULL, 'env' => 'SANDBOX', 'status' => '1', 'last_edit_by' => '1', 'created_at' => '2023-05-29 11:09:41', 'updated_at' => '2023-08-07 10:26:48'),
            array('id' => '5', 'slug' => 'add-money', 'code' => '120', 'type' => 'AUTOMATIC', 'name' => 'CoinGate', 'title' => 'Crypto Payment gateway', 'alias' => 'coingate', 'image' => '5f5ceacd-bd60-40ba-a8f2-438a90a47388.webp', 'credentials' => '[{"label":"Sandbox URL","placeholder":"Enter Sandbox URL","name":"sandbox-url","value":"https:\\/\\/api-sandbox.coingate.com\\/v2"},{"label":"Sandbox App Token","placeholder":"Enter Sandbox App Token","name":"sandbox-app-token","value":"XJW4RyhT8F-xssX2PvaHMWJjYe5nsbsrbb2Uqy4m"},{"label":"Production URL","placeholder":"Enter Production URL","name":"production-url","value":"https:\\/\\/api.coingate.com\\/v2"},{"label":"Production App Token","placeholder":"Enter Production App Token","name":"production-app-token","value":null}]', 'supported_currencies' => '["USD","BTC","LTC","ETH","BCH","TRX","ETC","DOGE","BTG","BNB","TUSD","USDT","BSV","MATIC","BUSD","SOL","WBTC","RVN","BCD","ATOM","BTTC","EURT"]', 'crypto' => '1', 'desc' => NULL, 'input_fields' => NULL, 'env' => 'SANDBOX', 'status' => '1', 'last_edit_by' => '1', 'created_at' => '2023-08-07 10:36:30', 'updated_at' => '2023-08-07 12:06:12'),
            array('id' => '6', 'slug' => 'add-money', 'code' => '125', 'type' => 'AUTOMATIC', 'name' => 'QRPay', 'title' => 'QRPay Gateway', 'alias' => 'qrpay', 'image' => '598a18a7-3e64-48ff-bb34-2663dad6c007.webp', 'credentials' => '[{"label":"Sandbox URL","placeholder":"Enter Sandbox URL","name":"sandbox-url","value":"https:\\/\\/qrpay.appdevs.net\\/pay\\/sandbox\\/api\\/v1"},{"label":"Production URL","placeholder":"Enter Production URL","name":"production-url","value":"https:\\/\\/qrpay.appdevs.net\\/pay\\/api\\/v1"},{"label":"Client ID","placeholder":"Enter Client ID","name":"client-id","value":"tRCDXCuztQzRYThPwlh1KXAYm4bG3rwWjbxM2R63kTefrGD2B9jNn6JnarDf7ycxdzfnaroxcyr5cnduY6AqpulRSebwHwRmGerA"},{"label":"Secret ID","placeholder":"Enter Secret ID","name":"secret-id","value":"oZouVmqHCbyg6ad7iMnrwq3d8wy9Kr4bo6VpQnsX6zAOoEs4oxHPjttpun36JhGxDl7AUMz3ShUqVyPmxh4oPk3TQmDF7YvHN5M3"}]', 'supported_currencies' => '["USD"]', 'crypto' => '0', 'desc' => NULL, 'input_fields' => NULL, 'env' => 'SANDBOX', 'status' => '1', 'last_edit_by' => '1', 'created_at' => '2023-08-14 14:57:29', 'updated_at' => '2024-10-10 18:50:04'),
            array('id' => '7', 'slug' => 'add-money', 'code' => '130', 'type' => 'MANUAL', 'name' => 'WISE', 'title' => 'WISE Gateway', 'alias' => 'wise', 'image' => '7c7e9935-b505-4cd2-a78f-d937f1e10ccd.webp', 'credentials' => NULL, 'supported_currencies' => '["USD"]', 'crypto' => '0', 'desc' => '<p>To initiate a payment using our manual payment gateway, please follow the instructions provided below. We offer two convenient methods for you to choose from:<br><strong>Option 1: PayPal Payment</strong></p><ol style="list-style-type:none;"><li>Log in to your PayPal account or access the PayPal website.</li><li>Choose the option to send money or make a payment.</li><li>Enter the recipient’s email address: <a href="mailto:business@paypal.com">business@paypal.com</a></li><li>Specify the payment amount in the currency you wish to use.</li><li>Make sure to select “Business” as the account type.</li><li>Review the payment details and confirm the transaction.</li><li>Keep the payment confirmation or receipt as proof of the transaction.</li></ol><p><strong>Option 2: Bank Transfer</strong></p><ol style="list-style-type:none;"><li>Visit your local bank or access your online banking platform.</li><li>Initiate a new fund transfer or payment.</li><li>Enter the recipient’s bank account details:</li></ol><ul style="list-style-type:none;"><li>Bank Name: Bank of America</li><li>IBAN (International Bank Account Number): 01234567890</li></ul><ol style="list-style-type:none;"><li>Specify the payment amount in the currency you intend to use.</li><li>Double-check all details, including the recipient’s account information.</li><li>Confirm and authorize the transfer.</li><li>Retain the payment receipt or confirmation for future reference.</li></ol><p>Please ensure that you keep a record of your payment as proof of the transaction. In case of any discrepancies or verification requirements, you may be asked to provide this documentation.Your payment will be manually verified by our team, and once confirmed, your order will be processed promptly. We appreciate your cooperation and look forward to serving you!</p>', 'input_fields' => '[{"type":"file","label":"Screenshot","name":"screenshot","required":false,"validation":{"max":"10","mimes":["jpg","png","webp","svg"],"min":0,"options":[],"required":false}},{"type":"text","label":"Transaction ID","name":"transaction_id","required":true,"validation":{"max":"60","mimes":[],"min":"0","options":[],"required":true}}]', 'env' => NULL, 'status' => '1', 'last_edit_by' => '1', 'created_at' => NULL, 'updated_at' => '2024-10-10 18:22:29'),
            array('id' => '8', 'slug' => 'add-money', 'code' => '135', 'type' => 'MANUAL', 'name' => 'UPI', 'title' => 'UPI Gateway', 'alias' => 'upi', 'image' => '703c4efe-8a34-4061-bcd6-2c5b165d6151.webp', 'credentials' => NULL, 'supported_currencies' => '["INR"]', 'crypto' => '0', 'desc' => '<p>To initiate a payment using our manual payment gateway, please follow the instructions provided below. We offer two convenient methods for you to choose from:<br><strong>Option 1: PayPal Payment</strong></p><ol style="list-style-type:none;"><li>Log in to your PayPal account or access the PayPal website.</li><li>Choose the option to send money or make a payment.</li><li>Enter the recipient’s email address: <a href="mailto:business@paypal.com">business@paypal.com</a></li><li>Specify the payment amount in the currency you wish to use.</li><li>Make sure to select “Business” as the account type.</li><li>Review the payment details and confirm the transaction.</li><li>Keep the payment confirmation or receipt as proof of the transaction.</li></ol><p><strong>Option 2: Bank Transfer</strong></p><ol style="list-style-type:none;"><li>Visit your local bank or access your online banking platform.</li><li>Initiate a new fund transfer or payment.</li><li>Enter the recipient’s bank account details:</li></ol><ul style="list-style-type:none;"><li>Bank Name: Bank of America</li><li>IBAN (International Bank Account Number): 01234567890</li></ul><ol style="list-style-type:none;"><li>Specify the payment amount in the currency you intend to use.</li><li>Double-check all details, including the recipient’s account information.</li><li>Confirm and authorize the transfer.</li><li>Retain the payment receipt or confirmation for future reference.</li></ol><p>Please ensure that you keep a record of your payment as proof of the transaction. In case of any discrepancies or verification requirements, you may be asked to provide this documentation.Your payment will be manually verified by our team, and once confirmed, your order will be processed promptly. We appreciate your cooperation and look forward to serving you!</p>', 'input_fields' => '[{"type":"file","label":"Screenshot","name":"screenshot","required":false,"validation":{"max":"10","mimes":["jpg","png","webp","svg"],"min":0,"options":[],"required":false}},{"type":"text","label":"Transaction ID","name":"transaction_id","required":true,"validation":{"max":"60","mimes":[],"min":"0","options":[],"required":true}}]', 'env' => NULL, 'status' => '1', 'last_edit_by' => '1', 'created_at' => NULL, 'updated_at' => '2024-10-10 18:22:53'),
            array('id' => '9', 'slug' => 'add-money', 'code' => '140', 'type' => 'MANUAL', 'name' => 'PayTM', 'title' => 'PayTM Gateway', 'alias' => 'paytm', 'image' => 'b3b7a39c-8866-4421-abf5-a9dace76ecac.webp', 'credentials' => NULL, 'supported_currencies' => '["INR"]', 'crypto' => '0', 'desc' => '<p>To initiate a payment using our manual payment gateway, please follow the instructions provided below. We offer two convenient methods for you to choose from:<br><strong>Option 1: PayPal Payment</strong></p><ol style="list-style-type:none;"><li>Log in to your PayPal account or access the PayPal website.</li><li>Choose the option to send money or make a payment.</li><li>Enter the recipient’s email address: <a href="mailto:business@paypal.com">business@paypal.com</a></li><li>Specify the payment amount in the currency you wish to use.</li><li>Make sure to select “Business” as the account type.</li><li>Review the payment details and confirm the transaction.</li><li>Keep the payment confirmation or receipt as proof of the transaction.</li></ol><p><strong>Option 2: Bank Transfer</strong></p><ol style="list-style-type:none;"><li>Visit your local bank or access your online banking platform.</li><li>Initiate a new fund transfer or payment.</li><li>Enter the recipient’s bank account details:</li></ol><ul style="list-style-type:none;"><li>Bank Name: Bank of America</li><li>IBAN (International Bank Account Number): 01234567890</li></ul><ol style="list-style-type:none;"><li>Specify the payment amount in the currency you intend to use.</li><li>Double-check all details, including the recipient’s account information.</li><li>Confirm and authorize the transfer.</li><li>Retain the payment receipt or confirmation for future reference.</li></ol><p>Please ensure that you keep a record of your payment as proof of the transaction. In case of any discrepancies or verification requirements, you may be asked to provide this documentation.Your payment will be manually verified by our team, and once confirmed, your order will be processed promptly. We appreciate your cooperation and look forward to serving you!</p>', 'input_fields' => '[{"type":"file","label":"Screenshot","name":"screenshot","required":false,"validation":{"max":"10","mimes":["jpg","png","webp","svg"],"min":0,"options":[],"required":false}},{"type":"text","label":"Transaction ID","name":"transaction_id","required":true,"validation":{"max":"60","mimes":[],"min":"0","options":[],"required":true}}]', 'env' => NULL, 'status' => '1', 'last_edit_by' => '1', 'created_at' => NULL, 'updated_at' => '2024-10-10 18:23:08'),
            array('id' => '10', 'slug' => 'add-money', 'code' => '145', 'type' => 'MANUAL', 'name' => 'PhonePe', 'title' => 'PhonePe Gateway', 'alias' => 'phonepe', 'image' => 'caf49da3-06e8-44bc-88bb-a195bee60d39.webp', 'credentials' => NULL, 'supported_currencies' => '["INR"]', 'crypto' => '0', 'desc' => '<p>To initiate a payment using our manual payment gateway, please follow the instructions provided below. We offer two convenient methods for you to choose from:<br><strong>Option 1: PayPal Payment</strong></p><ol style="list-style-type:none;"><li>Log in to your PayPal account or access the PayPal website.</li><li>Choose the option to send money or make a payment.</li><li>Enter the recipient’s email address: <a href="mailto:business@paypal.com">business@paypal.com</a></li><li>Specify the payment amount in the currency you wish to use.</li><li>Make sure to select “Business” as the account type.</li><li>Review the payment details and confirm the transaction.</li><li>Keep the payment confirmation or receipt as proof of the transaction.</li></ol><p><strong>Option 2: Bank Transfer</strong></p><ol style="list-style-type:none;"><li>Visit your local bank or access your online banking platform.</li><li>Initiate a new fund transfer or payment.</li><li>Enter the recipient’s bank account details:</li></ol><ul style="list-style-type:none;"><li>Bank Name: Bank of America</li><li>IBAN (International Bank Account Number): 01234567890</li></ul><ol style="list-style-type:none;"><li>Specify the payment amount in the currency you intend to use.</li><li>Double-check all details, including the recipient’s account information.</li><li>Confirm and authorize the transfer.</li><li>Retain the payment receipt or confirmation for future reference.</li></ol><p>Please ensure that you keep a record of your payment as proof of the transaction. In case of any discrepancies or verification requirements, you may be asked to provide this documentation.Your payment will be manually verified by our team, and once confirmed, your order will be processed promptly. We appreciate your cooperation and look forward to serving you!</p>', 'input_fields' => '[{"type":"file","label":"Screenshot","name":"screenshot","required":false,"validation":{"max":"10","mimes":["jpg","png","webp","svg"],"min":0,"options":[],"required":false}},{"type":"text","label":"Transaction ID","name":"transaction_id","required":true,"validation":{"max":"60","mimes":[],"min":"1","options":[],"required":true}}]', 'env' => NULL, 'status' => '1', 'last_edit_by' => '1', 'created_at' => NULL, 'updated_at' => '2024-10-10 18:23:28'),
            array('id' => '11', 'slug' => 'add-money', 'code' => '150', 'type' => 'MANUAL', 'name' => 'Khalti', 'title' => 'Khalti Gateway', 'alias' => 'khalti', 'image' => '0b150ac2-24a5-466d-b16f-6a4170b2e238.webp', 'credentials' => NULL, 'supported_currencies' => '["NPR"]', 'crypto' => '0', 'desc' => '<p>To initiate a payment using our manual payment gateway, please follow the instructions provided below. We offer two convenient methods for you to choose from:<br><strong>Option 1: PayPal Payment</strong></p><ol style="list-style-type:none;"><li>Log in to your PayPal account or access the PayPal website.</li><li>Choose the option to send money or make a payment.</li><li>Enter the recipient’s email address: <a href="mailto:business@paypal.com">business@paypal.com</a></li><li>Specify the payment amount in the currency you wish to use.</li><li>Make sure to select “Business” as the account type.</li><li>Review the payment details and confirm the transaction.</li><li>Keep the payment confirmation or receipt as proof of the transaction.</li></ol><p><strong>Option 2: Bank Transfer</strong></p><ol style="list-style-type:none;"><li>Visit your local bank or access your online banking platform.</li><li>Initiate a new fund transfer or payment.</li><li>Enter the recipient’s bank account details:</li></ol><ul style="list-style-type:none;"><li>Bank Name: Bank of America</li><li>IBAN (International Bank Account Number): 01234567890</li></ul><ol style="list-style-type:none;"><li>Specify the payment amount in the currency you intend to use.</li><li>Double-check all details, including the recipient’s account information.</li><li>Confirm and authorize the transfer.</li><li>Retain the payment receipt or confirmation for future reference.</li></ol><p>Please ensure that you keep a record of your payment as proof of the transaction. In case of any discrepancies or verification requirements, you may be asked to provide this documentation.Your payment will be manually verified by our team, and once confirmed, your order will be processed promptly. We appreciate your cooperation and look forward to serving you!</p>', 'input_fields' => '[{"type":"file","label":"Screenshot","name":"screenshot","required":false,"validation":{"max":"10","mimes":["jpg","png","webp","svg"],"min":0,"options":[],"required":false}},{"type":"text","label":"Transaction ID","name":"transaction_id","required":true,"validation":{"max":"60","mimes":[],"min":"1","options":[],"required":true}}]', 'env' => NULL, 'status' => '1', 'last_edit_by' => '1', 'created_at' => NULL, 'updated_at' => '2024-10-10 18:23:41'),
            array('id' => '12', 'slug' => 'add-money', 'code' => '155', 'type' => 'MANUAL', 'name' => 'PayStack', 'title' => 'PayStack Gateway', 'alias' => 'paystack', 'image' => '5af2018a-6e5b-4634-adb6-316b627eb437.webp', 'credentials' => NULL, 'supported_currencies' => '["NGN"]', 'crypto' => '0', 'desc' => '<p>To initiate a payment using our manual payment gateway, please follow the instructions provided below. We offer two convenient methods for you to choose from:<br><strong>Option 1: PayPal Payment</strong></p><ol style="list-style-type:none;"><li>Log in to your PayPal account or access the PayPal website.</li><li>Choose the option to send money or make a payment.</li><li>Enter the recipient’s email address: <a href="mailto:business@paypal.com">business@paypal.com</a></li><li>Specify the payment amount in the currency you wish to use.</li><li>Make sure to select “Business” as the account type.</li><li>Review the payment details and confirm the transaction.</li><li>Keep the payment confirmation or receipt as proof of the transaction.</li></ol><p><strong>Option 2: Bank Transfer</strong></p><ol style="list-style-type:none;"><li>Visit your local bank or access your online banking platform.</li><li>Initiate a new fund transfer or payment.</li><li>Enter the recipient’s bank account details:</li></ol><ul style="list-style-type:none;"><li>Bank Name: Bank of America</li><li>IBAN (International Bank Account Number): 01234567890</li></ul><ol style="list-style-type:none;"><li>Specify the payment amount in the currency you intend to use.</li><li>Double-check all details, including the recipient’s account information.</li><li>Confirm and authorize the transfer.</li><li>Retain the payment receipt or confirmation for future reference.</li></ol><p>Please ensure that you keep a record of your payment as proof of the transaction. In case of any discrepancies or verification requirements, you may be asked to provide this documentation.Your payment will be manually verified by our team, and once confirmed, your order will be processed promptly. We appreciate your cooperation and look forward to serving you!</p>', 'input_fields' => '[{"type":"file","label":"Screenshot","name":"screenshot","required":false,"validation":{"max":"10","mimes":["jpg","png","webp","svg"],"min":0,"options":[],"required":false}},{"type":"text","label":"Transaction ID","name":"transaction_id","required":true,"validation":{"max":"60","mimes":[],"min":"1","options":[],"required":true}}]', 'env' => NULL, 'status' => '1', 'last_edit_by' => '1', 'created_at' => NULL, 'updated_at' => '2024-10-10 18:23:54'),
            array('id' => '13', 'slug' => 'add-money', 'code' => '160', 'type' => 'MANUAL', 'name' => 'JazzCash', 'title' => 'JazzCash Gateway', 'alias' => 'jazzcash', 'image' => 'a1c00009-f3f3-463b-9b25-a647c2421050.webp', 'credentials' => NULL, 'supported_currencies' => '["PKR"]', 'crypto' => '0', 'desc' => '<p>To initiate a payment using our manual payment gateway, please follow the instructions provided below. We offer two convenient methods for you to choose from:<br><strong>Option 1: PayPal Payment</strong></p><ol style="list-style-type:none;"><li>Log in to your PayPal account or access the PayPal website.</li><li>Choose the option to send money or make a payment.</li><li>Enter the recipient’s email address: <a href="mailto:business@paypal.com">business@paypal.com</a></li><li>Specify the payment amount in the currency you wish to use.</li><li>Make sure to select “Business” as the account type.</li><li>Review the payment details and confirm the transaction.</li><li>Keep the payment confirmation or receipt as proof of the transaction.</li></ol><p><strong>Option 2: Bank Transfer</strong></p><ol style="list-style-type:none;"><li>Visit your local bank or access your online banking platform.</li><li>Initiate a new fund transfer or payment.</li><li>Enter the recipient’s bank account details:</li></ol><ul style="list-style-type:none;"><li>Bank Name: Bank of America</li><li>IBAN (International Bank Account Number): 01234567890</li></ul><ol style="list-style-type:none;"><li>Specify the payment amount in the currency you intend to use.</li><li>Double-check all details, including the recipient’s account information.</li><li>Confirm and authorize the transfer.</li><li>Retain the payment receipt or confirmation for future reference.</li></ol><p>Please ensure that you keep a record of your payment as proof of the transaction. In case of any discrepancies or verification requirements, you may be asked to provide this documentation.Your payment will be manually verified by our team, and once confirmed, your order will be processed promptly. We appreciate your cooperation and look forward to serving you!</p>', 'input_fields' => '[{"type":"file","label":"Screenshot","name":"screenshot","required":false,"validation":{"max":"10","mimes":["jpg","png","webp","svg"],"min":0,"options":[],"required":false}},{"type":"text","label":"Transaction ID","name":"transaction_id","required":true,"validation":{"max":"60","mimes":[],"min":"1","options":[],"required":true}}]', 'env' => NULL, 'status' => '1', 'last_edit_by' => '1', 'created_at' => NULL, 'updated_at' => '2024-10-10 18:24:08'),
            array('id' => '14', 'slug' => 'add-money', 'code' => '165', 'type' => 'MANUAL', 'name' => 'EasyPaisa', 'title' => 'EasyPaisa Gateway', 'alias' => 'easypaisa', 'image' => 'cf3d1b52-b1f6-4859-b7ea-6429bdd503e8.webp', 'credentials' => NULL, 'supported_currencies' => '["PKR"]', 'crypto' => '0', 'desc' => '<p>To initiate a payment using our manual payment gateway, please follow the instructions provided below. We offer two convenient methods for you to choose from:<br><strong>Option 1: PayPal Payment</strong></p><ol style="list-style-type:none;"><li>Log in to your PayPal account or access the PayPal website.</li><li>Choose the option to send money or make a payment.</li><li>Enter the recipient’s email address: <a href="mailto:business@paypal.com">business@paypal.com</a></li><li>Specify the payment amount in the currency you wish to use.</li><li>Make sure to select “Business” as the account type.</li><li>Review the payment details and confirm the transaction.</li><li>Keep the payment confirmation or receipt as proof of the transaction.</li></ol><p><strong>Option 2: Bank Transfer</strong></p><ol style="list-style-type:none;"><li>Visit your local bank or access your online banking platform.</li><li>Initiate a new fund transfer or payment.</li><li>Enter the recipient’s bank account details:</li></ol><ul style="list-style-type:none;"><li>Bank Name: Bank of America</li><li>IBAN (International Bank Account Number): 01234567890</li></ul><ol style="list-style-type:none;"><li>Specify the payment amount in the currency you intend to use.</li><li>Double-check all details, including the recipient’s account information.</li><li>Confirm and authorize the transfer.</li><li>Retain the payment receipt or confirmation for future reference.</li></ol><p>Please ensure that you keep a record of your payment as proof of the transaction. In case of any discrepancies or verification requirements, you may be asked to provide this documentation.Your payment will be manually verified by our team, and once confirmed, your order will be processed promptly. We appreciate your cooperation and look forward to serving you!</p>', 'input_fields' => '[{"type":"file","label":"Screenshot","name":"screenshot","required":false,"validation":{"max":"10","mimes":["jpg","png","webp","svg"],"min":0,"options":[],"required":false}},{"type":"text","label":"Transaction ID","name":"transaction_id","required":true,"validation":{"max":"60","mimes":[],"min":"1","options":[],"required":true}}]', 'env' => NULL, 'status' => '1', 'last_edit_by' => '1', 'created_at' => NULL, 'updated_at' => '2024-10-10 18:24:21'),
            array('id' => '15', 'slug' => 'money-out', 'code' => '170', 'type' => 'MANUAL', 'name' => 'PayPal', 'title' => 'PayPal Gateway', 'alias' => 'paypal', 'image' => NULL, 'credentials' => NULL, 'supported_currencies' => '["USD"]', 'crypto' => '0', 'desc' => '<p>To initiate a payment using our manual payment gateway, please follow the instructions provided below. We offer two convenient methods for you to choose from:<br><strong>Option 1: PayPal Payment</strong></p><ol style="list-style-type:none;"><li>Log in to your PayPal account or access the PayPal website.</li><li>Choose the option to send money or make a payment.</li><li>Enter the recipient’s email address: <a href="mailto:business@paypal.com">business@paypal.com</a></li><li>Specify the payment amount in the currency you wish to use.</li><li>Make sure to select “Business” as the account type.</li><li>Review the payment details and confirm the transaction.</li><li>Keep the payment confirmation or receipt as proof of the transaction.</li></ol><p><strong>Option 2: Bank Transfer</strong></p><ol style="list-style-type:none;"><li>Visit your local bank or access your online banking platform.</li><li>Initiate a new fund transfer or payment.</li><li>Enter the recipient’s bank account details:</li></ol><ul style="list-style-type:none;"><li>Bank Name: Bank of America</li><li>IBAN (International Bank Account Number): 01234567890</li></ul><ol style="list-style-type:none;"><li>Specify the payment amount in the currency you intend to use.</li><li>Double-check all details, including the recipient’s account information.</li><li>Confirm and authorize the transfer.</li><li>Retain the payment receipt or confirmation for future reference.</li></ol><p>Please ensure that you keep a record of your payment as proof of the transaction. In case of any discrepancies or verification requirements, you may be asked to provide this documentation.Your payment will be manually verified by our team, and once confirmed, your order will be processed promptly. We appreciate your cooperation and look forward to serving you!</p>', 'input_fields' => '[{"type":"file","label":"Screenshot","name":"screenshot","required":false,"validation":{"max":"10","mimes":["jpg","png","webp","svg"],"min":"0","options":[],"required":false}},{"type":"text","label":"Transaction ID","name":"transaction_id","required":true,"validation":{"max":"60","mimes":[],"min":"1","options":[],"required":true}}]', 'env' => NULL, 'status' => '1', 'last_edit_by' => '1', 'created_at' => NULL, 'updated_at' => NULL),
            array('id' => '16', 'slug' => 'money-out', 'code' => '175', 'type' => 'MANUAL', 'name' => 'WISE', 'title' => 'WISE Gateway', 'alias' => 'wise', 'image' => NULL, 'credentials' => NULL, 'supported_currencies' => '["USD"]', 'crypto' => '0', 'desc' => '<p>To initiate a payment using our manual payment gateway, please follow the instructions provided below. We offer two convenient methods for you to choose from:<br><strong>Option 1: PayPal Payment</strong></p><ol style="list-style-type:none;"><li>Log in to your PayPal account or access the PayPal website.</li><li>Choose the option to send money or make a payment.</li><li>Enter the recipient’s email address: <a href="mailto:business@paypal.com">business@paypal.com</a></li><li>Specify the payment amount in the currency you wish to use.</li><li>Make sure to select “Business” as the account type.</li><li>Review the payment details and confirm the transaction.</li><li>Keep the payment confirmation or receipt as proof of the transaction.</li></ol><p><strong>Option 2: Bank Transfer</strong></p><ol style="list-style-type:none;"><li>Visit your local bank or access your online banking platform.</li><li>Initiate a new fund transfer or payment.</li><li>Enter the recipient’s bank account details:</li></ol><ul style="list-style-type:none;"><li>Bank Name: Bank of America</li><li>IBAN (International Bank Account Number): 01234567890</li></ul><ol style="list-style-type:none;"><li>Specify the payment amount in the currency you intend to use.</li><li>Double-check all details, including the recipient’s account information.</li><li>Confirm and authorize the transfer.</li><li>Retain the payment receipt or confirmation for future reference.</li></ol><p>Please ensure that you keep a record of your payment as proof of the transaction. In case of any discrepancies or verification requirements, you may be asked to provide this documentation.Your payment will be manually verified by our team, and once confirmed, your order will be processed promptly. We appreciate your cooperation and look forward to serving you!</p>', 'input_fields' => '[{"type":"file","label":"Screenshot","name":"screenshot","required":false,"validation":{"max":"10","mimes":["jpg","png","webp","svg"],"min":"0","options":[],"required":false}},{"type":"text","label":"Transaction ID","name":"transaction_id","required":true,"validation":{"max":"60","mimes":[],"min":"1","options":[],"required":true}}]', 'env' => NULL, 'status' => '1', 'last_edit_by' => '1', 'created_at' => NULL, 'updated_at' => NULL),
            array('id' => '17', 'slug' => 'money-out', 'code' => '180', 'type' => 'MANUAL', 'name' => 'UPI', 'title' => 'UPI Gateway', 'alias' => 'upi', 'image' => NULL, 'credentials' => NULL, 'supported_currencies' => '["INR"]', 'crypto' => '0', 'desc' => '<p>To initiate a payment using our manual payment gateway, please follow the instructions provided below. We offer two convenient methods for you to choose from:<br><strong>Option 1: PayPal Payment</strong></p><ol style="list-style-type:none;"><li>Log in to your PayPal account or access the PayPal website.</li><li>Choose the option to send money or make a payment.</li><li>Enter the recipient’s email address: <a href="mailto:business@paypal.com">business@paypal.com</a></li><li>Specify the payment amount in the currency you wish to use.</li><li>Make sure to select “Business” as the account type.</li><li>Review the payment details and confirm the transaction.</li><li>Keep the payment confirmation or receipt as proof of the transaction.</li></ol><p><strong>Option 2: Bank Transfer</strong></p><ol style="list-style-type:none;"><li>Visit your local bank or access your online banking platform.</li><li>Initiate a new fund transfer or payment.</li><li>Enter the recipient’s bank account details:</li></ol><ul style="list-style-type:none;"><li>Bank Name: Bank of America</li><li>IBAN (International Bank Account Number): 01234567890</li></ul><ol style="list-style-type:none;"><li>Specify the payment amount in the currency you intend to use.</li><li>Double-check all details, including the recipient’s account information.</li><li>Confirm and authorize the transfer.</li><li>Retain the payment receipt or confirmation for future reference.</li></ol><p>Please ensure that you keep a record of your payment as proof of the transaction. In case of any discrepancies or verification requirements, you may be asked to provide this documentation.Your payment will be manually verified by our team, and once confirmed, your order will be processed promptly. We appreciate your cooperation and look forward to serving you!</p>', 'input_fields' => '[{"type":"file","label":"Screenshot","name":"screenshot","required":false,"validation":{"max":"10","mimes":["jpg","png","webp","svg"],"min":"0","options":[],"required":false}},{"type":"text","label":"Transaction ID","name":"transaction_id","required":true,"validation":{"max":"60","mimes":[],"min":"1","options":[],"required":true}}]', 'env' => NULL, 'status' => '1', 'last_edit_by' => '1', 'created_at' => NULL, 'updated_at' => NULL),
            array('id' => '18', 'slug' => 'money-out', 'code' => '185', 'type' => 'MANUAL', 'name' => 'PayTM', 'title' => 'PayTM Gateway', 'alias' => 'paytm', 'image' => NULL, 'credentials' => NULL, 'supported_currencies' => '["INR"]', 'crypto' => '0', 'desc' => '<p>To initiate a payment using our manual payment gateway, please follow the instructions provided below. We offer two convenient methods for you to choose from:<br><strong>Option 1: PayPal Payment</strong></p><ol style="list-style-type:none;"><li>Log in to your PayPal account or access the PayPal website.</li><li>Choose the option to send money or make a payment.</li><li>Enter the recipient’s email address: <a href="mailto:business@paypal.com">business@paypal.com</a></li><li>Specify the payment amount in the currency you wish to use.</li><li>Make sure to select “Business” as the account type.</li><li>Review the payment details and confirm the transaction.</li><li>Keep the payment confirmation or receipt as proof of the transaction.</li></ol><p><strong>Option 2: Bank Transfer</strong></p><ol style="list-style-type:none;"><li>Visit your local bank or access your online banking platform.</li><li>Initiate a new fund transfer or payment.</li><li>Enter the recipient’s bank account details:</li></ol><ul style="list-style-type:none;"><li>Bank Name: Bank of America</li><li>IBAN (International Bank Account Number): 01234567890</li></ul><ol style="list-style-type:none;"><li>Specify the payment amount in the currency you intend to use.</li><li>Double-check all details, including the recipient’s account information.</li><li>Confirm and authorize the transfer.</li><li>Retain the payment receipt or confirmation for future reference.</li></ol><p>Please ensure that you keep a record of your payment as proof of the transaction. In case of any discrepancies or verification requirements, you may be asked to provide this documentation.Your payment will be manually verified by our team, and once confirmed, your order will be processed promptly. We appreciate your cooperation and look forward to serving you!</p>', 'input_fields' => '[{"type":"file","label":"Screenshot","name":"screenshot","required":false,"validation":{"max":"10","mimes":["jpg","png","webp","svg"],"min":"0","options":[],"required":false}},{"type":"text","label":"Transaction ID","name":"transaction_id","required":true,"validation":{"max":"60","mimes":[],"min":"1","options":[],"required":true}}]', 'env' => NULL, 'status' => '1', 'last_edit_by' => '1', 'created_at' => NULL, 'updated_at' => NULL),
            array('id' => '19', 'slug' => 'money-out', 'code' => '190', 'type' => 'MANUAL', 'name' => 'PhonePe', 'title' => 'PhonePe Gateway', 'alias' => 'phonepe', 'image' => NULL, 'credentials' => NULL, 'supported_currencies' => '["INR"]', 'crypto' => '0', 'desc' => '<p>To initiate a payment using our manual payment gateway, please follow the instructions provided below. We offer two convenient methods for you to choose from:<br><strong>Option 1: PayPal Payment</strong></p><ol style="list-style-type:none;"><li>Log in to your PayPal account or access the PayPal website.</li><li>Choose the option to send money or make a payment.</li><li>Enter the recipient’s email address: <a href="mailto:business@paypal.com">business@paypal.com</a></li><li>Specify the payment amount in the currency you wish to use.</li><li>Make sure to select “Business” as the account type.</li><li>Review the payment details and confirm the transaction.</li><li>Keep the payment confirmation or receipt as proof of the transaction.</li></ol><p><strong>Option 2: Bank Transfer</strong></p><ol style="list-style-type:none;"><li>Visit your local bank or access your online banking platform.</li><li>Initiate a new fund transfer or payment.</li><li>Enter the recipient’s bank account details:</li></ol><ul style="list-style-type:none;"><li>Bank Name: Bank of America</li><li>IBAN (International Bank Account Number): 01234567890</li></ul><ol style="list-style-type:none;"><li>Specify the payment amount in the currency you intend to use.</li><li>Double-check all details, including the recipient’s account information.</li><li>Confirm and authorize the transfer.</li><li>Retain the payment receipt or confirmation for future reference.</li></ol><p>Please ensure that you keep a record of your payment as proof of the transaction. In case of any discrepancies or verification requirements, you may be asked to provide this documentation.Your payment will be manually verified by our team, and once confirmed, your order will be processed promptly. We appreciate your cooperation and look forward to serving you!</p>', 'input_fields' => '[{"type":"file","label":"Screenshot","name":"screenshot","required":false,"validation":{"max":"10","mimes":["jpg","png","webp","svg"],"min":"0","options":[],"required":false}},{"type":"text","label":"Transaction ID","name":"transaction_id","required":true,"validation":{"max":"60","mimes":[],"min":"1","options":[],"required":true}}]', 'env' => NULL, 'status' => '1', 'last_edit_by' => '1', 'created_at' => NULL, 'updated_at' => NULL),
            array('id' => '20', 'slug' => 'money-out', 'code' => '195', 'type' => 'MANUAL', 'name' => 'Khalti', 'title' => 'Khalti Gateway', 'alias' => 'khalti', 'image' => NULL, 'credentials' => NULL, 'supported_currencies' => '["NPR"]', 'crypto' => '0', 'desc' => '<p>To initiate a payment using our manual payment gateway, please follow the instructions provided below. We offer two convenient methods for you to choose from:<br><strong>Option 1: PayPal Payment</strong></p><ol style="list-style-type:none;"><li>Log in to your PayPal account or access the PayPal website.</li><li>Choose the option to send money or make a payment.</li><li>Enter the recipient’s email address: <a href="mailto:business@paypal.com">business@paypal.com</a></li><li>Specify the payment amount in the currency you wish to use.</li><li>Make sure to select “Business” as the account type.</li><li>Review the payment details and confirm the transaction.</li><li>Keep the payment confirmation or receipt as proof of the transaction.</li></ol><p><strong>Option 2: Bank Transfer</strong></p><ol style="list-style-type:none;"><li>Visit your local bank or access your online banking platform.</li><li>Initiate a new fund transfer or payment.</li><li>Enter the recipient’s bank account details:</li></ol><ul style="list-style-type:none;"><li>Bank Name: Bank of America</li><li>IBAN (International Bank Account Number): 01234567890</li></ul><ol style="list-style-type:none;"><li>Specify the payment amount in the currency you intend to use.</li><li>Double-check all details, including the recipient’s account information.</li><li>Confirm and authorize the transfer.</li><li>Retain the payment receipt or confirmation for future reference.</li></ol><p>Please ensure that you keep a record of your payment as proof of the transaction. In case of any discrepancies or verification requirements, you may be asked to provide this documentation.Your payment will be manually verified by our team, and once confirmed, your order will be processed promptly. We appreciate your cooperation and look forward to serving you!</p>', 'input_fields' => '[{"type":"file","label":"Screenshot","name":"screenshot","required":false,"validation":{"max":"10","mimes":["jpg","png","webp","svg"],"min":"0","options":[],"required":false}},{"type":"text","label":"Transaction ID","name":"transaction_id","required":true,"validation":{"max":"60","mimes":[],"min":"1","options":[],"required":true}}]', 'env' => NULL, 'status' => '1', 'last_edit_by' => '1', 'created_at' => NULL, 'updated_at' => NULL),
            array('id' => '21', 'slug' => 'money-out', 'code' => '200', 'type' => 'MANUAL', 'name' => 'PayStack', 'title' => 'PayStack Gateway', 'alias' => 'paystack', 'image' => NULL, 'credentials' => NULL, 'supported_currencies' => '["NGN"]', 'crypto' => '0', 'desc' => '<p>To initiate a payment using our manual payment gateway, please follow the instructions provided below. We offer two convenient methods for you to choose from:<br><strong>Option 1: PayPal Payment</strong></p><ol style="list-style-type:none;"><li>Log in to your PayPal account or access the PayPal website.</li><li>Choose the option to send money or make a payment.</li><li>Enter the recipient’s email address: <a href="mailto:business@paypal.com">business@paypal.com</a></li><li>Specify the payment amount in the currency you wish to use.</li><li>Make sure to select “Business” as the account type.</li><li>Review the payment details and confirm the transaction.</li><li>Keep the payment confirmation or receipt as proof of the transaction.</li></ol><p><strong>Option 2: Bank Transfer</strong></p><ol style="list-style-type:none;"><li>Visit your local bank or access your online banking platform.</li><li>Initiate a new fund transfer or payment.</li><li>Enter the recipient’s bank account details:</li></ol><ul style="list-style-type:none;"><li>Bank Name: Bank of America</li><li>IBAN (International Bank Account Number): 01234567890</li></ul><ol style="list-style-type:none;"><li>Specify the payment amount in the currency you intend to use.</li><li>Double-check all details, including the recipient’s account information.</li><li>Confirm and authorize the transfer.</li><li>Retain the payment receipt or confirmation for future reference.</li></ol><p>Please ensure that you keep a record of your payment as proof of the transaction. In case of any discrepancies or verification requirements, you may be asked to provide this documentation.Your payment will be manually verified by our team, and once confirmed, your order will be processed promptly. We appreciate your cooperation and look forward to serving you!</p>', 'input_fields' => '[{"type":"file","label":"Screenshot","name":"screenshot","required":false,"validation":{"max":"10","mimes":["jpg","png","webp","svg"],"min":"0","options":[],"required":false}},{"type":"text","label":"Transaction ID","name":"transaction_id","required":true,"validation":{"max":"60","mimes":[],"min":"1","options":[],"required":true}}]', 'env' => NULL, 'status' => '1', 'last_edit_by' => '1', 'created_at' => NULL, 'updated_at' => NULL),
            array('id' => '22', 'slug' => 'money-out', 'code' => '205', 'type' => 'MANUAL', 'name' => 'JazzCash', 'title' => 'JazzCash Gateway', 'alias' => 'jazzcash', 'image' => NULL, 'credentials' => NULL, 'supported_currencies' => '["PKR"]', 'crypto' => '0', 'desc' => '<p>To initiate a payment using our manual payment gateway, please follow the instructions provided below. We offer two convenient methods for you to choose from:<br><strong>Option 1: PayPal Payment</strong></p><ol style="list-style-type:none;"><li>Log in to your PayPal account or access the PayPal website.</li><li>Choose the option to send money or make a payment.</li><li>Enter the recipient’s email address: <a href="mailto:business@paypal.com">business@paypal.com</a></li><li>Specify the payment amount in the currency you wish to use.</li><li>Make sure to select “Business” as the account type.</li><li>Review the payment details and confirm the transaction.</li><li>Keep the payment confirmation or receipt as proof of the transaction.</li></ol><p><strong>Option 2: Bank Transfer</strong></p><ol style="list-style-type:none;"><li>Visit your local bank or access your online banking platform.</li><li>Initiate a new fund transfer or payment.</li><li>Enter the recipient’s bank account details:</li></ol><ul style="list-style-type:none;"><li>Bank Name: Bank of America</li><li>IBAN (International Bank Account Number): 01234567890</li></ul><ol style="list-style-type:none;"><li>Specify the payment amount in the currency you intend to use.</li><li>Double-check all details, including the recipient’s account information.</li><li>Confirm and authorize the transfer.</li><li>Retain the payment receipt or confirmation for future reference.</li></ol><p>Please ensure that you keep a record of your payment as proof of the transaction. In case of any discrepancies or verification requirements, you may be asked to provide this documentation.Your payment will be manually verified by our team, and once confirmed, your order will be processed promptly. We appreciate your cooperation and look forward to serving you!</p>', 'input_fields' => '[{"type":"file","label":"Screenshot","name":"screenshot","required":false,"validation":{"max":"10","mimes":["jpg","png","webp","svg"],"min":"0","options":[],"required":false}},{"type":"text","label":"Transaction ID","name":"transaction_id","required":true,"validation":{"max":"60","mimes":[],"min":"1","options":[],"required":true}}]', 'env' => NULL, 'status' => '1', 'last_edit_by' => '1', 'created_at' => NULL, 'updated_at' => NULL),
            array('id' => '23', 'slug' => 'money-out', 'code' => '210', 'type' => 'MANUAL', 'name' => 'EasyPaisa', 'title' => 'EasyPaisa Gateway', 'alias' => 'easypaisa', 'image' => NULL, 'credentials' => NULL, 'supported_currencies' => '["PKR"]', 'crypto' => '0', 'desc' => '<p>To initiate a payment using our manual payment gateway, please follow the instructions provided below. We offer two convenient methods for you to choose from:<br><strong>Option 1: PayPal Payment</strong></p><ol style="list-style-type:none;"><li>Log in to your PayPal account or access the PayPal website.</li><li>Choose the option to send money or make a payment.</li><li>Enter the recipient’s email address: <a href="mailto:business@paypal.com">business@paypal.com</a></li><li>Specify the payment amount in the currency you wish to use.</li><li>Make sure to select “Business” as the account type.</li><li>Review the payment details and confirm the transaction.</li><li>Keep the payment confirmation or receipt as proof of the transaction.</li></ol><p><strong>Option 2: Bank Transfer</strong></p><ol style="list-style-type:none;"><li>Visit your local bank or access your online banking platform.</li><li>Initiate a new fund transfer or payment.</li><li>Enter the recipient’s bank account details:</li></ol><ul style="list-style-type:none;"><li>Bank Name: Bank of America</li><li>IBAN (International Bank Account Number): 01234567890</li></ul><ol style="list-style-type:none;"><li>Specify the payment amount in the currency you intend to use.</li><li>Double-check all details, including the recipient’s account information.</li><li>Confirm and authorize the transfer.</li><li>Retain the payment receipt or confirmation for future reference.</li></ol><p>Please ensure that you keep a record of your payment as proof of the transaction. In case of any discrepancies or verification requirements, you may be asked to provide this documentation.Your payment will be manually verified by our team, and once confirmed, your order will be processed promptly. We appreciate your cooperation and look forward to serving you!</p>', 'input_fields' => '[{"type":"file","label":"Screenshot","name":"screenshot","required":false,"validation":{"max":"10","mimes":["jpg","png","webp","svg"],"min":"0","options":[],"required":false}},{"type":"text","label":"Transaction ID","name":"transaction_id","required":true,"validation":{"max":"60","mimes":[],"min":"1","options":[],"required":true}}]', 'env' => NULL, 'status' => '1', 'last_edit_by' => '1', 'created_at' => NULL, 'updated_at' => NULL),
            array('id' => '5000', 'slug' => 'add-money', 'code' => '10005', 'type' => 'AUTOMATIC', 'name' => 'Tatum', 'title' => 'Tatum Gateway', 'alias' => 'tatum', 'image' => '56ac53ea-d06f-4419-87da-6aa905fb055c.webp', 'credentials' => '[{"label":"Testnet","placeholder":"Enter Testnet","name":"test-net","value":"t-64c8e10396979a001d135363-64c8e10496979a001d135367"},{"label":"Mainnet","placeholder":"Enter Mainnet","name":"main-net","value":"t-64c8e10396979a001d135363-64c8e10496979a001d135369"}]', 'supported_currencies' => '["BTC","ETH","SOL"]', 'crypto' => '1', 'desc' => NULL, 'input_fields' => NULL, 'env' => 'SANDBOX', 'status' => '1', 'last_edit_by' => '1', 'created_at' => '2023-11-07 17:05:37', 'updated_at' => '2024-10-10 18:16:38'),
            array('id' => '5001', 'slug' => 'add-money', 'code' => '10010', 'type' => 'AUTOMATIC', 'name' => 'Stripe', 'title' => 'Stripe Gateway', 'alias' => 'stripe', 'image' => 'b854dcdc-c026-430e-b7ea-84350a985fe6.webp', 'credentials' => '[{"label":"Test Publishable Key","placeholder":"Enter Test Publishable Key","name":"test-publishable-key","value":"pk_test_51NECrlJXLo7QTdMco2E4YxHSeoBnDvKmmi0CZl3hxjGgH1JwgcLVUF3ZR0yFraoRgT7hf0LtOReFADhShAZqTNuB003PnBSlGP"},{"label":"Test Secret Key","placeholder":"Enter Test Secret Key","name":"test-secret-key","value":"sk_test_51NECrlJXLo7QTdMc2x7K5LaDuiS0MGNYHkO9dzzV0Y9XuWNZsXjECFsusjZEnqtxMIjCh3qtogc5sHHwL2oQ083900aFy1k7DE"},{"label":"Live Publishable Key","placeholder":"Enter Live Publishable Key","name":"live-publishable-key","value":null},{"label":"Live Secret Key","placeholder":"Enter Live Secret Key","name":"live-secret-key","value":null}]', 'supported_currencies' => '["USD","AUD","AED","BDT","BGN","CAD","EGP","EUR","GBP","INR","PKR","MYR","NGN"]', 'crypto' => '0', 'desc' => NULL, 'input_fields' => NULL, 'env' => 'SANDBOX', 'status' => '1', 'last_edit_by' => '1', 'created_at' => '2023-11-07 18:31:10', 'updated_at' => '2024-10-10 18:17:44'),
            array('id' => '5002', 'slug' => 'add-money', 'code' => '10015', 'type' => 'AUTOMATIC', 'name' => 'Flutterwave', 'title' => 'Flutterwave Gateway', 'alias' => 'flutterwave', 'image' => 'ef47d8c3-4597-411c-82e9-2d12f0ed4256.webp', 'credentials' => '[{"label":"Public Key","placeholder":"Enter Public Key","name":"public-key","value":"FLWPUBK_TEST-e0bc02a00395b938a4a2bed65e1bc94f-X"},{"label":"Secret Key","placeholder":"Enter Secret Key","name":"secret-key","value":"FLWSECK_TEST-da35e3dbd28be1e7dc5d5f3519e2ebef-X"},{"label":"Encryption key","placeholder":"Enter Encryption key","name":"encryption-key","value":"FLWSECK_TEST27bee2235efd"}]', 'supported_currencies' => '["AED", "ARS", "AUD", "CAD", "CHF", "CZK", "ETB", "EUR", "GBP", "GHS", "ILS", "INR", "JPY", "KES", "MAD", "MUR", "MYR", "NGN", "NOK", "NZD", "PEN", "PLN", "RUB", "RWF", "SAR", "SEK", "SGD", "SLL", "TZS", "UGX", "USD", "XAF", "XOF", "ZAR", "ZMK", "ZMW", "MWK"]', 'crypto' => '0', 'desc' => NULL, 'input_fields' => NULL, 'env' => 'SANDBOX', 'status' => '1', 'last_edit_by' => '1', 'created_at' => '2023-11-08 12:40:33', 'updated_at' => '2024-10-10 18:18:50'),
            array('id' => '5003', 'slug' => 'add-money', 'code' => '10020', 'type' => 'AUTOMATIC', 'name' => 'SSLCOMMERZ', 'title' => 'SSLCOMMERZ Gateway', 'alias' => 'sslcommerz', 'image' => '15a6ad06-7c94-4555-8a30-12f6c4ed775e.webp', 'credentials' => '[{"label":"Store ID","placeholder":"Enter Store ID","name":"store-id","value":"appde654c6741c4609"},{"label":"Store Password (API\\/Secret Key)","placeholder":"Enter Store Password (API\\/Secret Key)","name":"secret-key","value":"appde654c6741c4609@ssl"}]', 'supported_currencies' => '["BDT","USD","EUR","SGD","INR","MYR","GBP","AUD"]', 'crypto' => '0', 'desc' => NULL, 'input_fields' => NULL, 'env' => 'SANDBOX', 'status' => '1', 'last_edit_by' => '1', 'created_at' => '2023-11-09 12:58:17', 'updated_at' => '2024-10-10 18:21:36'),
            array('id' => '5004', 'slug' => 'add-money', 'code' => '10025', 'type' => 'AUTOMATIC', 'name' => 'Razorpay', 'title' => 'Razorpay Gateway', 'alias' => 'razorpay', 'image' => '9ecbf1f6-bfc3-4105-a7b6-11160a3139f0.webp', 'credentials' => '[{"label":"Key ID","placeholder":"Enter Key ID","name":"key-id","value":"rzp_test_B6FCT9ZBZylfoY"},{"label":"Secret Key","placeholder":"Enter Secret Key","name":"secret-key","value":"s4UYHtNwq5TkHSexU5Pnp1pm"}]', 'supported_currencies' => '["USD","EUR","GBP","SGD","AED","AUD","CAD","CNY","SEK","NZD","MXN","BDT","EGP","HKD","INR","LBP","LKR","MAD","MYR","NGN","NPR","PHP","PKR","QAR","SAR","UZS","GHS"]', 'crypto' => '0', 'desc' => NULL, 'input_fields' => NULL, 'env' => 'SANDBOX', 'status' => '1', 'last_edit_by' => '1', 'created_at' => '2023-11-09 17:26:21', 'updated_at' => '2024-10-10 18:20:15'),
            array('id' => '10000', 'slug' => 'add-money', 'code' => '20000', 'type' => 'AUTOMATIC', 'name' => 'Perfect Money', 'title' => 'Perfect Money Gateway', 'alias' => 'perfect-money', 'image' => '0dd81420-707d-434f-8dc3-8473065dcdc5.webp', 'credentials' => '[{"label":"USD Account","placeholder":"Enter USD Account","name":"usd-account","value":null},{"label":"EUR Account","placeholder":"Enter EUR Account","name":"eur-account","value":null},{"label":"Alternate Passphrase","placeholder":"Enter Alternate Passphrase","name":"alternate_passphrase","value":null}]', 'supported_currencies' => '["USD","EUR"]', 'crypto' => '0', 'desc' => NULL, 'input_fields' => NULL, 'env' => 'SANDBOX', 'status' => '1', 'last_edit_by' => '1', 'created_at' => '2023-12-30 16:05:59', 'updated_at' => '2024-10-10 18:20:52')
        );
        PaymentGateway::upsert($payment_gateways, ['code'], []);

        // Insert Payment Gateway Currencies
        $payment_gateway_currencies = array(
            array('payment_gateway_id' => '1', 'name' => 'Paypal CAD', 'alias' => 'add-money-paypal-cad-automatic', 'currency_code' => 'CAD', 'currency_symbol' => '$', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '5000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '0.00000000', 'rate' => '1.36000000', 'created_at' => '2023-05-29 11:15:57', 'updated_at' => '2023-08-07 10:26:48'),
            array('payment_gateway_id' => '1', 'name' => 'Paypal MYR', 'alias' => 'add-money-paypal-myr-automatic', 'currency_code' => 'MYR', 'currency_symbol' => 'RM', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '5000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '0.00000000', 'rate' => '4.61000000', 'created_at' => '2023-05-29 11:15:57', 'updated_at' => '2023-08-07 10:26:48'),
            array('payment_gateway_id' => '1', 'name' => 'Paypal GBP', 'alias' => 'add-money-paypal-gbp-automatic', 'currency_code' => 'GBP', 'currency_symbol' => '£', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '5000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '0.00000000', 'rate' => '0.81000000', 'created_at' => '2023-05-29 11:15:57', 'updated_at' => '2023-08-07 10:26:48'),
            array('payment_gateway_id' => '1', 'name' => 'Paypal USD', 'alias' => 'add-money-paypal-usd-automatic', 'currency_code' => 'USD', 'currency_symbol' => '$', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '5000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '0.00000000', 'rate' => '1.00000000', 'created_at' => '2023-05-29 11:15:57', 'updated_at' => '2023-08-07 10:26:48'),
            array('payment_gateway_id' => '5', 'name' => 'CoinGate BNB', 'alias' => 'add-money-coingate-bnb-automatic', 'currency_code' => 'BNB', 'currency_symbol' => 'BNB', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '3.00000000', 'fixed_charge' => '0.00000000', 'rate' => '0.00410000', 'created_at' => '2023-08-07 12:06:12', 'updated_at' => '2023-08-07 12:36:10'),
            array('payment_gateway_id' => '5', 'name' => 'CoinGate BTG', 'alias' => 'add-money-coingate-btg-automatic', 'currency_code' => 'BTG', 'currency_symbol' => 'BTG', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '10000.00000000', 'percent_charge' => '3.00000000', 'fixed_charge' => '0.00000000', 'rate' => '0.06600000', 'created_at' => '2023-08-07 12:06:12', 'updated_at' => '2023-08-07 12:36:10'),
            array('payment_gateway_id' => '5', 'name' => 'CoinGate DOGE', 'alias' => 'add-money-coingate-doge-automatic', 'currency_code' => 'DOGE', 'currency_symbol' => 'Ð', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '10000.00000000', 'percent_charge' => '3.00000000', 'fixed_charge' => '0.00000000', 'rate' => '13.37000000', 'created_at' => '2023-08-07 12:06:12', 'updated_at' => '2023-08-07 12:36:10'),
            array('payment_gateway_id' => '5', 'name' => 'CoinGate ETC', 'alias' => 'add-money-coingate-etc-automatic', 'currency_code' => 'ETC', 'currency_symbol' => 'ETC', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '10000.00000000', 'percent_charge' => '3.00000000', 'fixed_charge' => '0.00000000', 'rate' => '0.05600000', 'created_at' => '2023-08-07 12:06:12', 'updated_at' => '2023-08-07 12:36:10'),
            array('payment_gateway_id' => '5', 'name' => 'CoinGate TRX', 'alias' => 'add-money-coingate-trx-automatic', 'currency_code' => 'TRX', 'currency_symbol' => 'TRX', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '10000.00000000', 'percent_charge' => '3.00000000', 'fixed_charge' => '0.00000000', 'rate' => '12.99000000', 'created_at' => '2023-08-07 12:06:12', 'updated_at' => '2023-08-07 12:36:10'),
            array('payment_gateway_id' => '5', 'name' => 'CoinGate BCH', 'alias' => 'add-money-coingate-bch-automatic', 'currency_code' => 'BCH', 'currency_symbol' => 'BCH', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '10000.00000000', 'percent_charge' => '3.00000000', 'fixed_charge' => '0.00000000', 'rate' => '0.00430000', 'created_at' => '2023-08-07 12:06:12', 'updated_at' => '2023-08-07 12:36:10'),
            array('payment_gateway_id' => '5', 'name' => 'CoinGate LTC', 'alias' => 'add-money-coingate-ltc-automatic', 'currency_code' => 'LTC', 'currency_symbol' => 'Ł', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '10000.00000000', 'percent_charge' => '3.00000000', 'fixed_charge' => '0.00000000', 'rate' => '0.01200000', 'created_at' => '2023-08-07 12:06:12', 'updated_at' => '2023-08-07 12:36:10'),
            array('payment_gateway_id' => '5', 'name' => 'CoinGate ETH', 'alias' => 'add-money-coingate-eth-automatic', 'currency_code' => 'ETH', 'currency_symbol' => 'Ξ', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '10000.00000000', 'percent_charge' => '3.00000000', 'fixed_charge' => '0.00000000', 'rate' => '0.00054000', 'created_at' => '2023-08-07 12:06:12', 'updated_at' => '2023-08-07 12:36:10'),
            array('payment_gateway_id' => '5', 'name' => 'CoinGate BTC', 'alias' => 'add-money-coingate-btc-automatic', 'currency_code' => 'BTC', 'currency_symbol' => '₿', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '10000.00000000', 'percent_charge' => '3.00000000', 'fixed_charge' => '0.00000000', 'rate' => '0.00003400', 'created_at' => '2023-08-07 12:06:12', 'updated_at' => '2023-08-07 12:36:10'),
            array('payment_gateway_id' => '5', 'name' => 'CoinGate USD', 'alias' => 'add-money-coingate-usd-automatic', 'currency_code' => 'USD', 'currency_symbol' => '$', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '10000.00000000', 'percent_charge' => '3.00000000', 'fixed_charge' => '0.00000000', 'rate' => '1.00000000', 'created_at' => '2023-08-07 12:06:12', 'updated_at' => '2023-08-07 12:36:10'),
            array('payment_gateway_id' => '5', 'name' => 'CoinGate BTTC', 'alias' => 'add-money-coingate-bttc-automatic', 'currency_code' => 'BTTC', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '10000.00000000', 'percent_charge' => '3.00000000', 'fixed_charge' => '0.00000000', 'rate' => '2150539.00000000', 'created_at' => '2023-08-07 12:36:10', 'updated_at' => '2023-08-07 12:36:10'),
            array('payment_gateway_id' => '5', 'name' => 'CoinGate EURT', 'alias' => 'add-money-coingate-eurt-automatic', 'currency_code' => 'EURT', 'currency_symbol' => '€', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '10000.00000000', 'percent_charge' => '3.00000000', 'fixed_charge' => '0.00000000', 'rate' => '0.91000000', 'created_at' => '2023-08-07 12:36:10', 'updated_at' => '2023-08-07 12:36:10'),
            array('payment_gateway_id' => '5', 'name' => 'CoinGate ATOM', 'alias' => 'add-money-coingate-atom-automatic', 'currency_code' => 'ATOM', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '10000.00000000', 'percent_charge' => '3.00000000', 'fixed_charge' => '0.00000000', 'rate' => '0.12000000', 'created_at' => '2023-08-07 12:36:10', 'updated_at' => '2023-08-07 12:36:10'),
            array('payment_gateway_id' => '5', 'name' => 'CoinGate BCD', 'alias' => 'add-money-coingate-bcd-automatic', 'currency_code' => 'BCD', 'currency_symbol' => 'BCD', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '10000.00000000', 'percent_charge' => '3.00000000', 'fixed_charge' => '0.00000000', 'rate' => '18.20000000', 'created_at' => '2023-08-07 12:36:10', 'updated_at' => '2023-08-07 12:36:10'),
            array('payment_gateway_id' => '5', 'name' => 'CoinGate RVN', 'alias' => 'add-money-coingate-rvn-automatic', 'currency_code' => 'RVN', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '10000.00000000', 'percent_charge' => '3.00000000', 'fixed_charge' => '0.00000000', 'rate' => '55.37000000', 'created_at' => '2023-08-07 12:36:10', 'updated_at' => '2023-08-07 12:36:10'),
            array('payment_gateway_id' => '5', 'name' => 'CoinGate WBTC', 'alias' => 'add-money-coingate-wbtc-automatic', 'currency_code' => 'WBTC', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '10000.00000000', 'percent_charge' => '3.00000000', 'fixed_charge' => '0.00000000', 'rate' => '0.00003400', 'created_at' => '2023-08-07 12:36:10', 'updated_at' => '2023-08-07 12:36:10'),
            array('payment_gateway_id' => '5', 'name' => 'CoinGate SOL', 'alias' => 'add-money-coingate-sol-automatic', 'currency_code' => 'SOL', 'currency_symbol' => '☉', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '10000.00000000', 'percent_charge' => '3.00000000', 'fixed_charge' => '0.00000000', 'rate' => '3.67000000', 'created_at' => '2023-08-07 12:36:10', 'updated_at' => '2023-08-07 12:36:10'),
            array('payment_gateway_id' => '5', 'name' => 'CoinGate BUSD', 'alias' => 'add-money-coingate-busd-automatic', 'currency_code' => 'BUSD', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '10000.00000000', 'percent_charge' => '3.00000000', 'fixed_charge' => '0.00000000', 'rate' => '1.00100000', 'created_at' => '2023-08-07 12:36:10', 'updated_at' => '2023-08-07 12:36:10'),
            array('payment_gateway_id' => '5', 'name' => 'CoinGate MATIC', 'alias' => 'add-money-coingate-matic-automatic', 'currency_code' => 'MATIC', 'currency_symbol' => '$', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '10000.00000000', 'percent_charge' => '3.00000000', 'fixed_charge' => '0.00000000', 'rate' => '1.48000000', 'created_at' => '2023-08-07 12:36:10', 'updated_at' => '2023-08-07 12:36:10'),
            array('payment_gateway_id' => '5', 'name' => 'CoinGate BSV', 'alias' => 'add-money-coingate-bsv-automatic', 'currency_code' => 'BSV', 'currency_symbol' => 'BSV', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '10000.00000000', 'percent_charge' => '3.00000000', 'fixed_charge' => '0.00000000', 'rate' => '0.02839229', 'created_at' => '2023-08-07 12:36:10', 'updated_at' => '2023-08-07 12:36:10'),
            array('payment_gateway_id' => '5', 'name' => 'CoinGate USDT', 'alias' => 'add-money-coingate-usdt-automatic', 'currency_code' => 'USDT', 'currency_symbol' => '₮', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '10000.00000000', 'percent_charge' => '3.00000000', 'fixed_charge' => '0.00000000', 'rate' => '1.00000000', 'created_at' => '2023-08-07 12:36:10', 'updated_at' => '2023-08-07 12:36:10'),
            array('payment_gateway_id' => '5', 'name' => 'CoinGate TUSD', 'alias' => 'add-money-coingate-tusd-automatic', 'currency_code' => 'TUSD', 'currency_symbol' => '$', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '10000.00000000', 'percent_charge' => '3.00000000', 'fixed_charge' => '0.00000000', 'rate' => '1.00000000', 'created_at' => '2023-08-07 12:36:10', 'updated_at' => '2023-08-07 12:36:10'),
            array('payment_gateway_id' => '6', 'name' => 'QRPay USD', 'alias' => 'add-money-qrpay-usd-automatic', 'currency_code' => 'USD', 'currency_symbol' => '$', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '10000.00000000', 'percent_charge' => '3.00000000', 'fixed_charge' => '0.00000000', 'rate' => '1.00000000', 'created_at' => '2023-08-14 14:58:04', 'updated_at' => '2023-08-14 14:58:26'),
            array('payment_gateway_id' => '7', 'name' => 'WISE USD', 'alias' => 'add-money-wise-usd-manual', 'currency_code' => 'USD', 'currency_symbol' => '$', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '10000.00000000', 'percent_charge' => '3.00000000', 'fixed_charge' => '1.00000000', 'rate' => '1.00000000', 'created_at' => '2023-08-14 17:59:35', 'updated_at' => '2023-08-14 18:13:18'),
            array('payment_gateway_id' => '8', 'name' => 'UPI INR', 'alias' => 'add-money-upi-inr-manual', 'currency_code' => 'INR', 'currency_symbol' => '₹', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '10000.00000000', 'percent_charge' => '3.00000000', 'fixed_charge' => '1.00000000', 'rate' => '82.96000000', 'created_at' => '2023-08-14 18:02:02', 'updated_at' => '2023-08-14 18:13:36'),
            array('payment_gateway_id' => '9', 'name' => 'PayTM INR', 'alias' => 'add-money-paytm-inr-manual', 'currency_code' => 'INR', 'currency_symbol' => '₹', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '10000.00000000', 'percent_charge' => '3.00000000', 'fixed_charge' => '1.00000000', 'rate' => '82.96000000', 'created_at' => '2023-08-14 18:04:43', 'updated_at' => '2023-08-14 18:13:51'),
            array('payment_gateway_id' => '10', 'name' => 'PhonePe INR', 'alias' => 'add-money-phonepe-inr-manual', 'currency_code' => 'INR', 'currency_symbol' => '₹', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '10000.00000000', 'percent_charge' => '3.00000000', 'fixed_charge' => '1.00000000', 'rate' => '82.96000000', 'created_at' => '2023-08-14 18:06:04', 'updated_at' => '2023-08-14 18:15:51'),
            array('payment_gateway_id' => '11', 'name' => 'Khalti NPR', 'alias' => 'add-money-khalti-npr-manual', 'currency_code' => 'NPR', 'currency_symbol' => 'रु‎', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '10000.00000000', 'percent_charge' => '3.00000000', 'fixed_charge' => '1.00000000', 'rate' => '132.80000000', 'created_at' => '2023-08-14 18:07:42', 'updated_at' => '2023-08-14 18:16:01'),
            array('payment_gateway_id' => '12', 'name' => 'PayStack NGN', 'alias' => 'add-money-paystack-ngn-manual', 'currency_code' => 'NGN', 'currency_symbol' => '₦', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '10000.00000000', 'percent_charge' => '3.00000000', 'fixed_charge' => '1.00000000', 'rate' => '770.86000000', 'created_at' => '2023-08-14 18:09:32', 'updated_at' => '2023-08-14 18:16:12'),
            array('payment_gateway_id' => '13', 'name' => 'JazzCash PKR', 'alias' => 'add-money-jazzcash-pkr-manual', 'currency_code' => 'PKR', 'currency_symbol' => 'Rs', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '10000.00000000', 'percent_charge' => '3.00000000', 'fixed_charge' => '1.00000000', 'rate' => '289.38000000', 'created_at' => '2023-08-14 18:13:11', 'updated_at' => '2023-08-14 18:13:11'),
            array('payment_gateway_id' => '14', 'name' => 'EasyPaisa PKR', 'alias' => 'add-money-easypaisa-pkr-manual', 'currency_code' => 'PKR', 'currency_symbol' => 'Rs', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '10000.00000000', 'percent_charge' => '3.00000000', 'fixed_charge' => '1.00000000', 'rate' => '289.38000000', 'created_at' => '2023-08-14 18:17:13', 'updated_at' => '2023-08-14 18:17:13'),
            array('payment_gateway_id' => '15', 'name' => 'PayPal USD', 'alias' => 'money-out-paypal-usd-manual', 'currency_code' => 'USD', 'currency_symbol' => '$', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '10000.00000000', 'percent_charge' => '3.00000000', 'fixed_charge' => '1.00000000', 'rate' => '1.00000000', 'created_at' => '2023-08-14 18:19:29', 'updated_at' => '2023-08-14 18:19:29'),
            array('payment_gateway_id' => '16', 'name' => 'WISE USD', 'alias' => 'money-out-wise-usd-manual', 'currency_code' => 'USD', 'currency_symbol' => '$', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '10000.00000000', 'percent_charge' => '3.00000000', 'fixed_charge' => '1.00000000', 'rate' => '1.00000000', 'created_at' => '2023-08-14 18:20:23', 'updated_at' => '2023-08-14 18:20:23'),
            array('payment_gateway_id' => '17', 'name' => 'UPI INR', 'alias' => 'money-out-upi-inr-manual', 'currency_code' => 'INR', 'currency_symbol' => '₹', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '10000.00000000', 'percent_charge' => '3.00000000', 'fixed_charge' => '1.00000000', 'rate' => '82.96000000', 'created_at' => '2023-08-14 18:21:15', 'updated_at' => '2023-08-14 18:21:15'),
            array('payment_gateway_id' => '18', 'name' => 'PayTM INR', 'alias' => 'money-out-paytm-inr-manual', 'currency_code' => 'INR', 'currency_symbol' => '₹', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '10000.00000000', 'percent_charge' => '3.00000000', 'fixed_charge' => '1.00000000', 'rate' => '82.96000000', 'created_at' => '2023-08-14 18:22:02', 'updated_at' => '2023-08-14 18:22:02'),
            array('payment_gateway_id' => '19', 'name' => 'PhonePe INR', 'alias' => 'money-out-phonepe-inr-manual', 'currency_code' => 'INR', 'currency_symbol' => '₹', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '10000.00000000', 'percent_charge' => '3.00000000', 'fixed_charge' => '1.00000000', 'rate' => '82.96000000', 'created_at' => '2023-08-14 18:22:46', 'updated_at' => '2023-08-14 18:22:46'),
            array('payment_gateway_id' => '20', 'name' => 'Khalti NPR', 'alias' => 'money-out-khalti-npr-manual', 'currency_code' => 'NPR', 'currency_symbol' => 'रु‎', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '10000.00000000', 'percent_charge' => '3.00000000', 'fixed_charge' => '1.00000000', 'rate' => '132.88000000', 'created_at' => '2023-08-14 18:24:32', 'updated_at' => '2023-08-14 18:24:32'),
            array('payment_gateway_id' => '21', 'name' => 'PayStack NGN', 'alias' => 'money-out-paystack-ngn-manual', 'currency_code' => 'NGN', 'currency_symbol' => '₦', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '10000.00000000', 'percent_charge' => '3.00000000', 'fixed_charge' => '1.00000000', 'rate' => '770.86000000', 'created_at' => '2023-08-14 18:25:31', 'updated_at' => '2023-08-14 18:25:31'),
            array('payment_gateway_id' => '22', 'name' => 'JazzCash PKR', 'alias' => 'money-out-jazzcash-pkr-manual', 'currency_code' => 'PKR', 'currency_symbol' => 'Rs', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '10000.00000000', 'percent_charge' => '3.00000000', 'fixed_charge' => '1.00000000', 'rate' => '289.38000000', 'created_at' => '2023-08-14 18:26:24', 'updated_at' => '2023-08-14 18:26:24'),
            array('payment_gateway_id' => '23', 'name' => 'EasyPaisa PKR', 'alias' => 'money-out-easypaisa-pkr-manual', 'currency_code' => 'PKR', 'currency_symbol' => 'Rs', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '10000.00000000', 'percent_charge' => '3.00000000', 'fixed_charge' => '1.00000000', 'rate' => '289.38000000', 'created_at' => '2023-08-14 18:27:12', 'updated_at' => '2023-08-14 18:27:12'),

            array('payment_gateway_id' => '5000', 'name' => 'Tatum SOL', 'alias' => 'add-money-tatum-sol-automatic', 'currency_code' => 'SOL', 'currency_symbol' => 'SOL', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '20000.00000000', 'percent_charge' => '1.00000000', 'fixed_charge' => '1.00000000', 'rate' => '3.76000000', 'created_at' => '2023-11-07 17:10:38', 'updated_at' => '2023-11-07 17:44:00'),
            array('payment_gateway_id' => '5000', 'name' => 'Tatum ETH', 'alias' => 'add-money-tatum-eth-automatic', 'currency_code' => 'ETH', 'currency_symbol' => 'ETH', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '20000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '0.00052000', 'created_at' => '2023-11-07 17:10:38', 'updated_at' => '2023-11-07 17:44:00'),
            array('payment_gateway_id' => '5000', 'name' => 'Tatum BTC', 'alias' => 'add-money-tatum-btc-automatic', 'currency_code' => 'BTC', 'currency_symbol' => 'BTC', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '20000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '0.00002900', 'created_at' => '2023-11-07 17:10:38', 'updated_at' => '2023-11-07 17:44:00'),
            array('payment_gateway_id' => '5001', 'name' => 'Stripe NGN', 'alias' => 'add-money-stripe-ngn-automatic', 'currency_code' => 'NGN', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '799.93000000', 'created_at' => '2023-11-07 18:35:45', 'updated_at' => '2023-11-07 18:35:45'),
            array('payment_gateway_id' => '5001', 'name' => 'Stripe MYR', 'alias' => 'add-money-stripe-myr-automatic', 'currency_code' => 'MYR', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '4.66000000', 'created_at' => '2023-11-07 18:35:45', 'updated_at' => '2023-11-07 18:35:45'),
            array('payment_gateway_id' => '5001', 'name' => 'Stripe PKR', 'alias' => 'add-money-stripe-pkr-automatic', 'currency_code' => 'PKR', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '284.81000000', 'created_at' => '2023-11-07 18:35:45', 'updated_at' => '2023-11-07 18:35:45'),
            array('payment_gateway_id' => '5001', 'name' => 'Stripe INR', 'alias' => 'add-money-stripe-inr-automatic', 'currency_code' => 'INR', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '83.24000000', 'created_at' => '2023-11-07 18:35:45', 'updated_at' => '2023-11-07 18:35:45'),
            array('payment_gateway_id' => '5001', 'name' => 'Stripe GBP', 'alias' => 'add-money-stripe-gbp-automatic', 'currency_code' => 'GBP', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '0.81000000', 'created_at' => '2023-11-07 18:35:45', 'updated_at' => '2023-11-07 18:35:45'),
            array('payment_gateway_id' => '5001', 'name' => 'Stripe EUR', 'alias' => 'add-money-stripe-eur-automatic', 'currency_code' => 'EUR', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '0.94000000', 'created_at' => '2023-11-07 18:35:45', 'updated_at' => '2023-11-07 18:35:45'),
            array('payment_gateway_id' => '5001', 'name' => 'Stripe EGP', 'alias' => 'add-money-stripe-egp-automatic', 'currency_code' => 'EGP', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '30.91000000', 'created_at' => '2023-11-07 18:35:45', 'updated_at' => '2023-11-07 18:35:45'),
            array('payment_gateway_id' => '5001', 'name' => 'Stripe CAD', 'alias' => 'add-money-stripe-cad-automatic', 'currency_code' => 'CAD', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '1.37000000', 'created_at' => '2023-11-07 18:35:45', 'updated_at' => '2023-11-07 18:35:45'),
            array('payment_gateway_id' => '5001', 'name' => 'Stripe BGN', 'alias' => 'add-money-stripe-bgn-automatic', 'currency_code' => 'BGN', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '1.82000000', 'created_at' => '2023-11-07 18:35:45', 'updated_at' => '2023-11-07 18:35:45'),
            array('payment_gateway_id' => '5001', 'name' => 'Stripe BDT', 'alias' => 'add-money-stripe-bdt-automatic', 'currency_code' => 'BDT', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '110.65000000', 'created_at' => '2023-11-07 18:35:45', 'updated_at' => '2023-11-07 18:35:45'),
            array('payment_gateway_id' => '5001', 'name' => 'Stripe AED', 'alias' => 'add-money-stripe-aed-automatic', 'currency_code' => 'AED', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '3.67000000', 'created_at' => '2023-11-07 18:35:45', 'updated_at' => '2023-11-07 18:35:45'),
            array('payment_gateway_id' => '5001', 'name' => 'Stripe AUD', 'alias' => 'add-money-stripe-aud-automatic', 'currency_code' => 'AUD', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '1.54000000', 'created_at' => '2023-11-07 18:35:45', 'updated_at' => '2023-11-07 18:35:45'),
            array('payment_gateway_id' => '5001', 'name' => 'Stripe USD', 'alias' => 'add-money-stripe-usd-automatic', 'currency_code' => 'USD', 'currency_symbol' => '$', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '1.00000000', 'created_at' => '2023-11-07 18:35:45', 'updated_at' => '2023-11-07 18:35:45'),
            array('payment_gateway_id' => '5002', 'name' => 'Flutterwave MWK', 'alias' => 'add-money-flutterwave-mwk-automatic', 'currency_code' => 'MWK', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '1107.43000000', 'created_at' => '2023-11-08 13:01:40', 'updated_at' => '2023-11-08 13:01:40'),
            array('payment_gateway_id' => '5002', 'name' => 'Flutterwave ZMW', 'alias' => 'add-money-flutterwave-zmw-automatic', 'currency_code' => 'ZMW', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '22.50000000', 'created_at' => '2023-11-08 13:01:40', 'updated_at' => '2023-11-08 13:01:40'),
            array('payment_gateway_id' => '5002', 'name' => 'Flutterwave ZMK', 'alias' => 'add-money-flutterwave-zmk-automatic', 'currency_code' => 'ZMK', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '22.50000000', 'created_at' => '2023-11-08 13:01:40', 'updated_at' => '2023-11-08 13:01:40'),
            array('payment_gateway_id' => '5002', 'name' => 'Flutterwave ZAR', 'alias' => 'add-money-flutterwave-zar-automatic', 'currency_code' => 'ZAR', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '18.38000000', 'created_at' => '2023-11-08 13:01:40', 'updated_at' => '2023-11-08 13:01:40'),
            array('payment_gateway_id' => '5002', 'name' => 'Flutterwave XOF', 'alias' => 'add-money-flutterwave-xof-automatic', 'currency_code' => 'XOF', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '609.75000000', 'created_at' => '2023-11-08 13:01:40', 'updated_at' => '2023-11-08 13:01:40'),
            array('payment_gateway_id' => '5002', 'name' => 'Flutterwave XAF', 'alias' => 'add-money-flutterwave-xaf-automatic', 'currency_code' => 'XAF', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '613.96000000', 'created_at' => '2023-11-08 13:01:40', 'updated_at' => '2023-11-08 13:01:40'),
            array('payment_gateway_id' => '5002', 'name' => 'Flutterwave USD', 'alias' => 'add-money-flutterwave-usd-automatic', 'currency_code' => 'USD', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '1.00000000', 'created_at' => '2023-11-08 13:01:40', 'updated_at' => '2023-11-08 13:01:40'),
            array('payment_gateway_id' => '5002', 'name' => 'Flutterwave UGX', 'alias' => 'add-money-flutterwave-ugx-automatic', 'currency_code' => 'UGX', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '3757.00000000', 'created_at' => '2023-11-08 13:01:40', 'updated_at' => '2023-11-08 13:01:40'),
            array('payment_gateway_id' => '5002', 'name' => 'Flutterwave TZS', 'alias' => 'add-money-flutterwave-tzs-automatic', 'currency_code' => 'TZS', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '2500.00000000', 'created_at' => '2023-11-08 13:01:40', 'updated_at' => '2023-11-08 13:01:40'),
            array('payment_gateway_id' => '5002', 'name' => 'Flutterwave SLL', 'alias' => 'add-money-flutterwave-sll-automatic', 'currency_code' => 'SLL', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '21023.00000000', 'created_at' => '2023-11-08 13:01:40', 'updated_at' => '2023-11-08 13:01:40'),
            array('payment_gateway_id' => '5002', 'name' => 'Flutterwave SGD', 'alias' => 'add-money-flutterwave-sgd-automatic', 'currency_code' => 'SGD', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '1.36000000', 'created_at' => '2023-11-08 13:01:40', 'updated_at' => '2023-11-08 13:01:40'),
            array('payment_gateway_id' => '5002', 'name' => 'Flutterwave SEK', 'alias' => 'add-money-flutterwave-sek-automatic', 'currency_code' => 'SEK', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '10.94000000', 'created_at' => '2023-11-08 13:01:40', 'updated_at' => '2023-11-08 13:01:40'),
            array('payment_gateway_id' => '5002', 'name' => 'Flutterwave SAR', 'alias' => 'add-money-flutterwave-sar-automatic', 'currency_code' => 'SAR', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '3.75000000', 'created_at' => '2023-11-08 13:01:40', 'updated_at' => '2023-11-08 13:01:40'),
            array('payment_gateway_id' => '5002', 'name' => 'Flutterwave RWF', 'alias' => 'add-money-flutterwave-rwf-automatic', 'currency_code' => 'RWF', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '1219.98000000', 'created_at' => '2023-11-08 13:01:40', 'updated_at' => '2023-11-08 13:01:40'),
            array('payment_gateway_id' => '5002', 'name' => 'Flutterwave RUB', 'alias' => 'add-money-flutterwave-rub-automatic', 'currency_code' => 'RUB', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '92.35000000', 'created_at' => '2023-11-08 13:01:40', 'updated_at' => '2023-11-08 13:01:40'),
            array('payment_gateway_id' => '5002', 'name' => 'Flutterwave PLN', 'alias' => 'add-money-flutterwave-pln-automatic', 'currency_code' => 'PLN', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '4.17000000', 'created_at' => '2023-11-08 13:01:40', 'updated_at' => '2023-11-08 13:01:40'),
            array('payment_gateway_id' => '5002', 'name' => 'Flutterwave PEN', 'alias' => 'add-money-flutterwave-pen-automatic', 'currency_code' => 'PEN', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '3.76000000', 'created_at' => '2023-11-08 13:01:40', 'updated_at' => '2023-11-08 13:01:40'),
            array('payment_gateway_id' => '5002', 'name' => 'Flutterwave NZD', 'alias' => 'add-money-flutterwave-nzd-automatic', 'currency_code' => 'NZD', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '1.68000000', 'created_at' => '2023-11-08 13:01:40', 'updated_at' => '2023-11-08 13:01:40'),
            array('payment_gateway_id' => '5002', 'name' => 'Flutterwave NOK', 'alias' => 'add-money-flutterwave-nok-automatic', 'currency_code' => 'NOK', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '11.21000000', 'created_at' => '2023-11-08 13:01:40', 'updated_at' => '2023-11-08 13:01:40'),
            array('payment_gateway_id' => '5002', 'name' => 'Flutterwave NGN', 'alias' => 'add-money-flutterwave-ngn-automatic', 'currency_code' => 'NGN', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '780.00000000', 'created_at' => '2023-11-08 13:01:40', 'updated_at' => '2023-11-08 13:01:40'),
            array('payment_gateway_id' => '5002', 'name' => 'Flutterwave MYR', 'alias' => 'add-money-flutterwave-myr-automatic', 'currency_code' => 'MYR', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '4.67000000', 'created_at' => '2023-11-08 13:01:40', 'updated_at' => '2023-11-08 13:01:40'),
            array('payment_gateway_id' => '5002', 'name' => 'Flutterwave MUR', 'alias' => 'add-money-flutterwave-mur-automatic', 'currency_code' => 'MUR', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '44.05000000', 'created_at' => '2023-11-08 13:01:40', 'updated_at' => '2023-11-08 13:01:40'),
            array('payment_gateway_id' => '5002', 'name' => 'Flutterwave MAD', 'alias' => 'add-money-flutterwave-mad-automatic', 'currency_code' => 'MAD', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '10.22000000', 'created_at' => '2023-11-08 13:01:40', 'updated_at' => '2023-11-08 13:01:40'),
            array('payment_gateway_id' => '5002', 'name' => 'Flutterwave KES', 'alias' => 'add-money-flutterwave-kes-automatic', 'currency_code' => 'KES', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '151.30000000', 'created_at' => '2023-11-08 13:01:40', 'updated_at' => '2023-11-08 13:01:40'),
            array('payment_gateway_id' => '5002', 'name' => 'Flutterwave JPY', 'alias' => 'add-money-flutterwave-jpy-automatic', 'currency_code' => 'JPY', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '150.65000000', 'created_at' => '2023-11-08 13:01:40', 'updated_at' => '2023-11-08 13:01:40'),
            array('payment_gateway_id' => '5002', 'name' => 'Flutterwave INR', 'alias' => 'add-money-flutterwave-inr-automatic', 'currency_code' => 'INR', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '83.25000000', 'created_at' => '2023-11-08 13:01:40', 'updated_at' => '2023-11-08 13:01:40'),
            array('payment_gateway_id' => '5002', 'name' => 'Flutterwave ILS', 'alias' => 'add-money-flutterwave-ils-automatic', 'currency_code' => 'ILS', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '3.87000000', 'created_at' => '2023-11-08 13:01:40', 'updated_at' => '2023-11-08 13:01:40'),
            array('payment_gateway_id' => '5002', 'name' => 'Flutterwave GBP', 'alias' => 'add-money-flutterwave-gbp-automatic', 'currency_code' => 'GBP', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '0.81000000', 'created_at' => '2023-11-08 13:01:40', 'updated_at' => '2023-11-08 13:01:40'),
            array('payment_gateway_id' => '5002', 'name' => 'Flutterwave GHS', 'alias' => 'add-money-flutterwave-ghs-automatic', 'currency_code' => 'GHS', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '11.88000000', 'created_at' => '2023-11-08 13:01:40', 'updated_at' => '2023-11-08 13:01:40'),
            array('payment_gateway_id' => '5002', 'name' => 'Flutterwave EUR', 'alias' => 'add-money-flutterwave-eur-automatic', 'currency_code' => 'EUR', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '0.94000000', 'created_at' => '2023-11-08 13:01:40', 'updated_at' => '2023-11-08 13:01:40'),
            array('payment_gateway_id' => '5002', 'name' => 'Flutterwave ETB', 'alias' => 'add-money-flutterwave-etb-automatic', 'currency_code' => 'ETB', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '55.58000000', 'created_at' => '2023-11-08 13:01:40', 'updated_at' => '2023-11-08 13:01:40'),
            array('payment_gateway_id' => '5002', 'name' => 'Flutterwave CZK', 'alias' => 'add-money-flutterwave-czk-automatic', 'currency_code' => 'CZK', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '23.04000000', 'created_at' => '2023-11-08 13:01:40', 'updated_at' => '2023-11-08 13:01:40'),
            array('payment_gateway_id' => '5002', 'name' => 'Flutterwave CHF', 'alias' => 'add-money-flutterwave-chf-automatic', 'currency_code' => 'CHF', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '0.90000000', 'created_at' => '2023-11-08 13:01:40', 'updated_at' => '2023-11-08 13:01:40'),
            array('payment_gateway_id' => '5002', 'name' => 'Flutterwave CAD', 'alias' => 'add-money-flutterwave-cad-automatic', 'currency_code' => 'CAD', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '1.38000000', 'created_at' => '2023-11-08 13:01:40', 'updated_at' => '2023-11-08 13:01:40'),
            array('payment_gateway_id' => '5002', 'name' => 'Flutterwave AUD', 'alias' => 'add-money-flutterwave-aud-automatic', 'currency_code' => 'AUD', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '1.55000000', 'created_at' => '2023-11-08 13:01:40', 'updated_at' => '2023-11-08 13:01:40'),
            array('payment_gateway_id' => '5002', 'name' => 'Flutterwave ARS', 'alias' => 'add-money-flutterwave-ars-automatic', 'currency_code' => 'ARS', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '349.67000000', 'created_at' => '2023-11-08 13:01:40', 'updated_at' => '2023-11-08 13:01:40'),
            array('payment_gateway_id' => '5002', 'name' => 'Flutterwave AED', 'alias' => 'add-money-flutterwave-aed-automatic', 'currency_code' => 'AED', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '3.67000000', 'created_at' => '2023-11-08 13:01:40', 'updated_at' => '2023-11-08 13:01:40'),
            array('payment_gateway_id' => '5003', 'name' => 'SSLCOMMERZ AUD', 'alias' => 'add-money-sslcommerz-aud-automatic', 'currency_code' => 'AUD', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '1.56000000', 'created_at' => '2023-11-09 13:01:12', 'updated_at' => '2023-11-09 13:01:12'),
            array('payment_gateway_id' => '5003', 'name' => 'SSLCOMMERZ GBP', 'alias' => 'add-money-sslcommerz-gbp-automatic', 'currency_code' => 'GBP', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '0.81000000', 'created_at' => '2023-11-09 13:01:12', 'updated_at' => '2023-11-09 13:01:12'),
            array('payment_gateway_id' => '5003', 'name' => 'SSLCOMMERZ MYR', 'alias' => 'add-money-sslcommerz-myr-automatic', 'currency_code' => 'MYR', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '4.69000000', 'created_at' => '2023-11-09 13:01:12', 'updated_at' => '2023-11-09 13:01:12'),
            array('payment_gateway_id' => '5003', 'name' => 'SSLCOMMERZ INR', 'alias' => 'add-money-sslcommerz-inr-automatic', 'currency_code' => 'INR', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '83.26000000', 'created_at' => '2023-11-09 13:01:12', 'updated_at' => '2023-11-09 13:01:12'),
            array('payment_gateway_id' => '5003', 'name' => 'SSLCOMMERZ SGD', 'alias' => 'add-money-sslcommerz-sgd-automatic', 'currency_code' => 'SGD', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '1.36000000', 'created_at' => '2023-11-09 13:01:12', 'updated_at' => '2023-11-09 13:01:12'),
            array('payment_gateway_id' => '5003', 'name' => 'SSLCOMMERZ EUR', 'alias' => 'add-money-sslcommerz-eur-automatic', 'currency_code' => 'EUR', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '0.93000000', 'created_at' => '2023-11-09 13:01:12', 'updated_at' => '2023-11-09 13:01:12'),
            array('payment_gateway_id' => '5003', 'name' => 'SSLCOMMERZ USD', 'alias' => 'add-money-sslcommerz-usd-automatic', 'currency_code' => 'USD', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '1.00000000', 'created_at' => '2023-11-09 13:01:12', 'updated_at' => '2023-11-09 13:01:12'),
            array('payment_gateway_id' => '5003', 'name' => 'SSLCOMMERZ BDT', 'alias' => 'add-money-sslcommerz-bdt-automatic', 'currency_code' => 'BDT', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '110.00000000', 'created_at' => '2023-11-09 13:01:12', 'updated_at' => '2023-11-09 13:01:12'),
            array('payment_gateway_id' => '5004', 'name' => 'Razorpay GHS', 'alias' => 'add-money-razorpay-ghs-automatic', 'currency_code' => 'GHS', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '11.90000000', 'created_at' => '2023-11-09 17:36:05', 'updated_at' => '2023-11-09 17:36:05'),
            array('payment_gateway_id' => '5004', 'name' => 'Razorpay UZS', 'alias' => 'add-money-razorpay-uzs-automatic', 'currency_code' => 'UZS', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '12263.46000000', 'created_at' => '2023-11-09 17:36:05', 'updated_at' => '2023-11-09 17:36:05'),
            array('payment_gateway_id' => '5004', 'name' => 'Razorpay SAR', 'alias' => 'add-money-razorpay-sar-automatic', 'currency_code' => 'SAR', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '3.75000000', 'created_at' => '2023-11-09 17:36:05', 'updated_at' => '2023-11-09 17:36:05'),
            array('payment_gateway_id' => '5004', 'name' => 'Razorpay QAR', 'alias' => 'add-money-razorpay-qar-automatic', 'currency_code' => 'QAR', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '3.64000000', 'created_at' => '2023-11-09 17:36:05', 'updated_at' => '2023-11-09 17:36:05'),
            array('payment_gateway_id' => '5004', 'name' => 'Razorpay PKR', 'alias' => 'add-money-razorpay-pkr-automatic', 'currency_code' => 'PKR', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '286.50000000', 'created_at' => '2023-11-09 17:36:05', 'updated_at' => '2023-11-09 17:36:05'),
            array('payment_gateway_id' => '5004', 'name' => 'Razorpay PHP', 'alias' => 'add-money-razorpay-php-automatic', 'currency_code' => 'PHP', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '55.79000000', 'created_at' => '2023-11-09 17:36:05', 'updated_at' => '2023-11-09 17:36:05'),
            array('payment_gateway_id' => '5004', 'name' => 'Razorpay NPR', 'alias' => 'add-money-razorpay-npr-automatic', 'currency_code' => 'NPR', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '133.25000000', 'created_at' => '2023-11-09 17:36:05', 'updated_at' => '2023-11-09 17:36:05'),
            array('payment_gateway_id' => '5004', 'name' => 'Razorpay NGN', 'alias' => 'add-money-razorpay-ngn-automatic', 'currency_code' => 'NGN', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '780.00000000', 'created_at' => '2023-11-09 17:36:05', 'updated_at' => '2023-11-09 17:36:05'),
            array('payment_gateway_id' => '5004', 'name' => 'Razorpay MYR', 'alias' => 'add-money-razorpay-myr-automatic', 'currency_code' => 'MYR', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '4.69000000', 'created_at' => '2023-11-09 17:36:05', 'updated_at' => '2023-11-09 17:36:05'),
            array('payment_gateway_id' => '5004', 'name' => 'Razorpay MAD', 'alias' => 'add-money-razorpay-mad-automatic', 'currency_code' => 'MAD', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '10.21000000', 'created_at' => '2023-11-09 17:36:05', 'updated_at' => '2023-11-09 17:36:05'),
            array('payment_gateway_id' => '5004', 'name' => 'Razorpay LKR', 'alias' => 'add-money-razorpay-lkr-automatic', 'currency_code' => 'LKR', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '327.00000000', 'created_at' => '2023-11-09 17:36:05', 'updated_at' => '2023-11-09 17:36:05'),
            array('payment_gateway_id' => '5004', 'name' => 'Razorpay LBP', 'alias' => 'add-money-razorpay-lbp-automatic', 'currency_code' => 'LBP', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '15000.00000000', 'created_at' => '2023-11-09 17:36:05', 'updated_at' => '2023-11-09 17:36:05'),
            array('payment_gateway_id' => '5004', 'name' => 'Razorpay INR', 'alias' => 'add-money-razorpay-inr-automatic', 'currency_code' => 'INR', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '83.28000000', 'created_at' => '2023-11-09 17:36:05', 'updated_at' => '2023-11-09 17:36:05'),
            array('payment_gateway_id' => '5004', 'name' => 'Razorpay HKD', 'alias' => 'add-money-razorpay-hkd-automatic', 'currency_code' => 'HKD', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '7.81000000', 'created_at' => '2023-11-09 17:36:05', 'updated_at' => '2023-11-09 17:36:05'),
            array('payment_gateway_id' => '5004', 'name' => 'Razorpay EGP', 'alias' => 'add-money-razorpay-egp-automatic', 'currency_code' => 'EGP', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '30.85000000', 'created_at' => '2023-11-09 17:36:05', 'updated_at' => '2023-11-09 17:36:05'),
            array('payment_gateway_id' => '5004', 'name' => 'Razorpay BDT', 'alias' => 'add-money-razorpay-bdt-automatic', 'currency_code' => 'BDT', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '110.00000000', 'created_at' => '2023-11-09 17:36:05', 'updated_at' => '2023-11-09 17:36:05'),
            array('payment_gateway_id' => '5004', 'name' => 'Razorpay MXN', 'alias' => 'add-money-razorpay-mxn-automatic', 'currency_code' => 'MXN', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '17.57000000', 'created_at' => '2023-11-09 17:36:05', 'updated_at' => '2023-11-09 17:36:05'),
            array('payment_gateway_id' => '5004', 'name' => 'Razorpay NZD', 'alias' => 'add-money-razorpay-nzd-automatic', 'currency_code' => 'NZD', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '1.69000000', 'created_at' => '2023-11-09 17:36:05', 'updated_at' => '2023-11-09 17:36:05'),
            array('payment_gateway_id' => '5004', 'name' => 'Razorpay SEK', 'alias' => 'add-money-razorpay-sek-automatic', 'currency_code' => 'SEK', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '10.89000000', 'created_at' => '2023-11-09 17:36:05', 'updated_at' => '2023-11-09 17:36:05'),
            array('payment_gateway_id' => '5004', 'name' => 'Razorpay CNY', 'alias' => 'add-money-razorpay-cny-automatic', 'currency_code' => 'CNY', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '7.29000000', 'created_at' => '2023-11-09 17:36:05', 'updated_at' => '2023-11-09 17:36:05'),
            array('payment_gateway_id' => '5004', 'name' => 'Razorpay CAD', 'alias' => 'add-money-razorpay-cad-automatic', 'currency_code' => 'CAD', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '1.38000000', 'created_at' => '2023-11-09 17:36:05', 'updated_at' => '2023-11-09 17:36:05'),
            array('payment_gateway_id' => '5004', 'name' => 'Razorpay AUD', 'alias' => 'add-money-razorpay-aud-automatic', 'currency_code' => 'AUD', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '1.56000000', 'created_at' => '2023-11-09 17:36:05', 'updated_at' => '2023-11-09 17:36:05'),
            array('payment_gateway_id' => '5004', 'name' => 'Razorpay AED', 'alias' => 'add-money-razorpay-aed-automatic', 'currency_code' => 'AED', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '3.67000000', 'created_at' => '2023-11-09 17:36:05', 'updated_at' => '2023-11-09 17:36:05'),
            array('payment_gateway_id' => '5004', 'name' => 'Razorpay SGD', 'alias' => 'add-money-razorpay-sgd-automatic', 'currency_code' => 'SGD', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '1.36000000', 'created_at' => '2023-11-09 17:36:05', 'updated_at' => '2023-11-09 17:36:05'),
            array('payment_gateway_id' => '5004', 'name' => 'Razorpay GBP', 'alias' => 'add-money-razorpay-gbp-automatic', 'currency_code' => 'GBP', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '0.82000000', 'created_at' => '2023-11-09 17:36:05', 'updated_at' => '2023-11-09 17:36:05'),
            array('payment_gateway_id' => '5004', 'name' => 'Razorpay EUR', 'alias' => 'add-money-razorpay-eur-automatic', 'currency_code' => 'EUR', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '0.94000000', 'created_at' => '2023-11-09 17:36:05', 'updated_at' => '2023-11-09 17:36:05'),
            array('payment_gateway_id' => '5004', 'name' => 'Razorpay USD', 'alias' => 'add-money-razorpay-usd-automatic', 'currency_code' => 'USD', 'currency_symbol' => NULL, 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '1000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '1.00000000', 'created_at' => '2023-11-09 17:36:05', 'updated_at' => '2023-11-09 17:36:05'),

            array('payment_gateway_id' => '10000', 'name' => 'Perfect Money EUR', 'alias' => 'add-money-perfect-money-eur-automatic', 'currency_code' => 'EUR', 'currency_symbol' => '€', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '5000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '0.90000000', 'created_at' => '2023-12-30 16:44:49', 'updated_at' => '2024-01-01 06:27:26'),
            array('payment_gateway_id' => '10000', 'name' => 'Perfect Money USD', 'alias' => 'add-money-perfect-money-usd-automatic', 'currency_code' => 'USD', 'currency_symbol' => '$', 'image' => NULL, 'min_limit' => '1.00000000', 'max_limit' => '5000.00000000', 'percent_charge' => '2.00000000', 'fixed_charge' => '1.00000000', 'rate' => '1.00000000', 'created_at' => '2023-12-30 16:44:49', 'updated_at' => '2024-01-01 06:27:26')
        );
        PaymentGatewayCurrency::upsert($payment_gateway_currencies, ['alias'], []);
    }
}
